/*!
 	@file
 	@brief IME NX
 */

#ifndef CInputMethod_h
#define CInputMethod_h

#include"../Setup/CompileMode.h"
#include"../Auxiliary/Macro.h"
#include"../Auxiliary/mstring.h"
#include"Driver/CInputMethodDriver.h"

#include<boost/smart_ptr.hpp>
#include<boost/function.hpp>

namespace Maid
{
	/*!
	 	@class	CInputMethod CInputMethod.h
	 	@brief	IME NX
	\n			edoǗNX
	\n			̃NX͕`sȂ̂łق̃NXōsKv܂B
	 */

	class CInputMethod
	{
	public:
		void Initialize( const SPINPUTMETHODDRIVER& pDriver );


		void OnResult( const mstring& str );
		void SetResultFunction( const IInputMethodDriver::RESULTCODEFUNCTION& Function );

		bool IsOpen() const;
		mstring GetCompString() const;
		int GetCursorPos() const;

	private:
		SPINPUTMETHODDRIVER	m_pDriver;

		IInputMethodDriver::RESULTCODEFUNCTION	m_Function;
	};


}

#endif
