/*!
 	@file
 	@brief	L[{[h͂ǗNX
 */

#ifndef CKeybord_h
#define CKeybord_h

#include"Driver/CKeybordDriver.h"
#include"Driver/CInputDriver.h"

namespace Maid
{
	class CKeybord
	{
	public:
		CKeybord();
		~CKeybord();


		void Initialize( const SPKEYBORDDRIVER& pKey, const SPCHARCODEDRIVER& pChar );

		void Update();
		void Flash();

		bool	IsDown  ( unt08 KeyCode ) const;
		bool	IsIn    ( unt08 KeyCode ) const;
		bool	IsOut   ( unt08 KeyCode ) const;
		bool	IsRepeat( unt08 KeyCode, unt Frame  ) const;
		bool	IsRepeat( unt08 KeyCode, unt Frame, unt BeginFrame  ) const;

		void OnCharCode( unt32 code );
		void SetCharCodeFunction( const ICharCodeDriver::CHARCODEFUNCTION& Function );

		/*!
		 	@enum	KEYCODE CKeybord.h
		 	@brief	zL[R[h
		\n			IsDown(), IsClick() ̈Ɏg܂
		\n			eAt@xbg͑啶Ŏw肷邱  'A'
		 */
		enum KEYCODE
		{
			BUTTON_TAB   = 0x09,	//	tab
			BUTTON_ENTER = 0x0D,	//	s
			BUTTON_SHIFT = 0x10,	//	Vtg
			BUTTON_CTRL  = 0x11,	//	Ctrl
			BUTTON_ESC   = 0x1B,	//	GXP[v

			BUTTON_SPACE    = 0x20,	//	Xy[X
			BUTTON_PAGEUP   = 0x21,	//	y[WAbv
			BUTTON_PAGEDOWN = 0x22,	//	y[W_E
			BUTTON_END		= 0x23,	//	Ō
			BUTTON_HOME		= 0x24,	//	ŏ

			BUTTON_LEFT		= 0x25,	//	
			BUTTON_UP		= 0x26,	//	
			BUTTON_RIGHT	= 0x27,	//	
			BUTTON_DOWN		= 0x28,	//	

			BUTTON_INSERT	= 0x2D,	//	}
			BUTTON_DELETE	= 0x2E,	//	폜

			BUTTON_NUM0   = 0x30,		//	L[{[h '0'
			BUTTON_NUM1,				//	L[{[h '1'
			BUTTON_NUM2,				//	L[{[h '2'
			BUTTON_NUM3,				//	L[{[h '3'
			BUTTON_NUM4,				//	L[{[h '4'
			BUTTON_NUM5,				//	L[{[h '5'
			BUTTON_NUM6,				//	L[{[h '6'
			BUTTON_NUM7,				//	L[{[h '7'
			BUTTON_NUM8,				//	L[{[h '8'
			BUTTON_NUM9,				//	L[{[h '9'

			BUTTON_TEN0   = 0x60,		//	eL[ '0'
			BUTTON_TEN1,				//	eL[ '1'
			BUTTON_TEN2,				//	eL[ '2'
			BUTTON_TEN3,				//	eL[ '3'
			BUTTON_TEN4,				//	eL[ '4'
			BUTTON_TEN5,				//	eL[ '5'
			BUTTON_TEN6,				//	eL[ '6'
			BUTTON_TEN7,				//	eL[ '7'
			BUTTON_TEN8,				//	eL[ '8'
			BUTTON_TEN9,				//	eL[ '9'

			BUTTON_F01   = 0x70,	//	F01
			BUTTON_F02,				//	F02
			BUTTON_F03,				//	F03
			BUTTON_F04,				//	F04
			BUTTON_F05,				//	F05
			BUTTON_F06,				//	F06
			BUTTON_F07,				//	F07
			BUTTON_F08,				//	F08
			BUTTON_F09,				//	F09
//			BUTTON_F10 ȍ~͂Ȃ擾łȂ iEDE;j

			BUTTON_MAX=255
		};

	private:
		struct BUTTONSTATE
		{
			BUTTONSTATE() :DownCount(0),IsOut(false){}
			unt		DownCount;
			bool	IsOut;
		};

		MySTL::vector<BUTTONSTATE>	m_ButtonList;
		SPKEYBORDDRIVER		m_pKeybordDriver;
		SPCHARCODEDRIVER	m_pCharCodeDriver;


		ICharCodeDriver::CHARCODEFUNCTION	m_Function;
	};

}

#endif