#include"CMouse.h"
#include"../template/Collision.h"
#include"../auxiliary/Debug/CAssert.h"


namespace Maid
{
	/*!
	 	@class	CMouse CMouse.h
	 	@brief	}EX͂ǗNX
	 */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 */
CMouse::CMouse() : m_ClipRange(0,0,800,600), m_Mapping(0,0,800,600)
{

}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!
 */
CMouse::~CMouse()
{
	if( m_pMouseDriver.get()!=NULL ) { m_pMouseDriver->Finalize(); }
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EX̏
/*!
 	@param	pDriver	[i ]	Vݒ肷hCo
 */
void CMouse::Initialize( const SPMOUSEDRIVER& pDriver )
{
	m_pMouseDriver = pDriver;

	m_PosList.resize( m_pMouseDriver->GetPositionMax() );
	m_ButtonList.resize( m_pMouseDriver->GetButtonMax() );

	ZERO( &m_PosList[0], sizeof(int)*(unt)m_PosList.size() );
	ZERO( &m_ButtonList[0], sizeof(BUTTONSTATE)*(unt)m_ButtonList.size() );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EX̏ԂXV
/*!
 *	t[ɂPĂяo
 */
void CMouse::Update()
{
	MySTL::vector<bool> KeyList(m_ButtonList.size());
	m_PrevList = m_PosList;
	m_pMouseDriver->GetState( m_PosList, KeyList );

	m_RealPos.x = m_PosList[0];
	m_RealPos.y = m_PosList[1];

	//	m_Mapping Ƀ}bsO
	{
		int x = m_PosList[0];
		int y = m_PosList[1];

		x -= m_ClipRange.x;
		y -= m_ClipRange.y;

		x = x * m_Mapping.w / m_ClipRange.w;
		y = y * m_Mapping.h / m_ClipRange.h;

		x += m_Mapping.x;
		y += m_Mapping.y;

		m_PosList[0] = x;
		m_PosList[1] = y;
	}

/*
	m_PosList[0] -= m_Offset.x;
	m_PosList[1] -= m_Offset.y;
 *	Ƃ SetClipRange( 0,0,1024,768 ) ŁASetMapping(0,0,800,600)@ɂꍇ

*/

	for( unt i=0; i<KeyList.size(); ++i )
	{
		const bool IsDown  = KeyList[i];
		BUTTONSTATE& state = m_ButtonList[i];

		if( IsDown )
		{
			state.DownCount++;	//	I[o[t[邱Ƃ邯ǁEEEES(LM*)T
		}else
		{
			state.IsOut = state.DownCount!=0;
			state.DownCount = 0;
		}
	}


}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! w̒l擾
/*!
 	@return wl
 */
int CMouse::GetX() const
{
	return GetPos(0);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! x̒l擾
/*!
	@return xl
 */
int CMouse::GetY() const
{
	return GetPos(1);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! zC[̉]ʂ擾
/*!
	@return zC[̉]
 */
int CMouse::GetWheel() const
{
	return GetPos(2);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ëړʂ擾
/*!
 	@param	Index	[i ]	擾
  
	@return ړ
 */
int CMouse::GetPos( unt Index ) const
{
	MAID_ASSERT( !(Index<m_PosList.size()), "̎w肪ł " << Index << " " << m_PosList.size() );
	return m_PosList[Index];
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! w̑Ot[Ƃ̍擾
/*!
	@return wl
 */
int CMouse::GetDeltaX() const
{
	return GetDelta(0);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! x̑Ot[Ƃ̍擾
/*!
	@return xl
 */
int CMouse::GetDeltaY() const
{
	return GetDelta(1);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! zC[̉](Ot[Ƃ̍)擾
/*!
	@return zC[̉]
 */
int CMouse::GetDeltaWheel() const
{
	return GetDelta(2);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ȇOt[Ƃ̍擾
/*!
 	@param	Index	[i ]	擾
  
	@return ړ
 */
int CMouse::GetDelta( unt Index ) const
{
	MAID_ASSERT( !(Index<m_PosList.size()), "̎w肪ł " << Index << " " << m_PosList.size() );
	return m_PosList[Index]-m_PrevList[Index];
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! {^Ă邩ׂ
/*!
	@return Ă邩H
 */
bool CMouse::IsDownL() const
{
	return IsDown(0);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! E{^Ă邩ׂ
/*!
	@return Ă邩H
 */
bool CMouse::IsDownR() const
{
	return IsDown(1);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EXzC[{^Ă邩ׂ
/*!
	@return Ă邩H
 */
bool CMouse::IsDownWheel() const
{
	return IsDown(2);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! {^Ă邩ׂ
/*!
 *	\param	Index	[i ]	擾{^
 *
	@return Ă邩H
 */
bool CMouse::IsDown( unt Index ) const
{
	MAID_ASSERT( !(Index<m_ButtonList.size()), "̎w肪ł " << Index << " " << m_ButtonList.size() );
	return m_ButtonList[Index].DownCount!=0;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! {^ꂽuԂׂ
/*!
	@return Ă邩H
 */
bool CMouse::IsInL() const
{
	return IsIn(0);
}
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! E{^ꂽuԂׂ
/*!
	@return Ă邩H
 */
bool CMouse::IsInR() const
{
	return IsIn(1);
}
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! zC[{^ꂽuԂׂ
/*!
	@return Ă邩H
 */
bool CMouse::IsInWheel() const
{
	return IsIn(2);
}
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! w肵{^ꂽuԂׂ
/*!
	@return Ă邩H
 */
bool CMouse::IsIn( unt Index ) const
{
	MAID_ASSERT( !(Index<m_ButtonList.size()), "̎w肪ł " << Index << " " << m_ButtonList.size() );
	return m_ButtonList[Index].DownCount==1;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! {^ꂽuԂׂ
/*!
	@return Ă邩H
 */
bool CMouse::IsOutL() const
{
	return IsOut(0);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! E{^ꂽuԂׂ
/*!
	@return Ă邩H
 */
bool CMouse::IsOutR() const
{
	return IsOut(1);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! zC[{^ꂽuԂׂ
/*!
	@return Ă邩H
 */
bool CMouse::IsOutWheel() const
{
	return IsOut(2);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! w肵{^ꂽuԂׂ
/*!
	@return Ă邩H
 */
bool CMouse::IsOut( unt Index ) const
{
	MAID_ASSERT( !(Index<m_ButtonList.size()), "̎w肪ł " << Index << " " << m_ButtonList.size() );
	return m_ButtonList[Index].IsOut;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! {^s[gꂽuԂׂ
/*!
 	@param	Frame	[i ]	s[gԊu
 
	@return Ă邩H
 */
bool CMouse::IsRepeatL( unt Frame ) const
{
	return IsRepeat(0, Frame);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! E{^s[gꂽuԂׂ
/*!
 	@param	Frame	[i ]	s[gԊu
 
	@return Ă邩H
 */
bool CMouse::IsRepeatR( unt Frame ) const
{
	return IsRepeat(1, Frame);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! zC[{^s[gꂽuԂׂ
/*!
 	@param	Frame	[i ]	s[gԊu
 
	@return Ă邩H
 */
bool CMouse::IsRepeatWheel( unt Frame ) const
{
	return IsRepeat(2, Frame);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! w肵{^s[gꂽuԂׂ
/*!
 	@param	Index	[i ]	擾{^
 	@param	Frame	[i ]	s[gԊu
 
	@return Ă邩H
 */
bool CMouse::IsRepeat( unt Index, unt Frame  ) const
{
	return (m_ButtonList[Index].DownCount%Frame)==1;
}





/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EX͈̓͂̐ݒ
/*!
 	@param	Range	[i ]	}EX͈̔
 */
void CMouse::SetClipRange( const RECT2DI& Range )
{
	m_ClipRange = Range;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! SetClipRangeŐݒ肵WǂȍWŕϊ邩H
/*!
 	Ƃ SetClipRange( 0,0,1024,768 ) ŁASetMapping(0,0,800,600)@ɂꍇ
 	GetX(), GetY() œl 0,0,800,600 ͈̔͂ɂȂ
 
 	@param	map	[i ]	W̏o͔͈
 */
void CMouse::SetMapping( const RECT2DI& map )
{
	m_Mapping = map;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EXw肵Ă`ɓĂ邩H
/*!
	@return ͂ĂȂ true
\n			͂ĂȂȂ false
 */
bool CMouse::IsClipIn() const
{
	return Collision<int>::IsPointToRect( m_RealPos.x, m_RealPos.y,  m_ClipRange );
}


}

