/*!
 	@file
 	@brief	R[h擾hCo
\n			̃NXpĊenrƂ̋@\bv܂
 */

#ifndef CCharCodeDriver_h
#define CCharCodeDriver_h

#include"../../Setup/CompileMode.h"
#include"../../Auxiliary/Macro.h"
#include<boost/function.hpp>
#include<boost/bind.hpp>
#include<boost/smart_ptr.hpp>

namespace Maid
{
	/*!
	 	@class	ICharCodeDriver ICharCodeDriver.h
	 	@brief	R[h擾hCo
	\n			Ƃ L[{[h A ꍇ
	\n			a, A,  ̉\킯łAʂĂNX
	 */

	class ICharCodeDriver
	{
	public:
		virtual ~ICharCodeDriver()=0{};	//!<	fXgN^

		//! 
		/*!
		 */
		virtual void	Initialize()=0;

		//! 
		/*!
		 */
		virtual void		Finalize()=0;

		typedef boost::function1<void, unt32>	CHARCODEFUNCTION;

		//! R[h͂ꂽꍇAR[obN֐̐ݒ
		/*!
		 	@param	Function	[i ]	ݒ肷֐ void XXXX( STR ) ̌`ł邱
		\n								STR łɎʂꂽR[hɂȂ܂
		 */
		virtual void SetCallBack( const CHARCODEFUNCTION& Function )=0;
	};

	#define MakeCharCodeFunctionObject(pFunc,pObject) boost::bind( pFunc, pObject, _1 )

	typedef boost::shared_ptr<ICharCodeDriver> SPCHARCODEDRIVER;

}

#endif
