/*!
 	@file
 	@brief IME bpNX
 */

#ifndef CInputMethodDriverWindows_h
#define CInputMethodDriverWindows_h

#include"../../../Setup/CompileMode.h"
#include"../../../Setup/Win32.h"
#include"../../../Auxiliary/Macro.h"
#include"../../../Auxiliary/mstring.h"
#include"../../../FrameWork/Windows/CMessageHook.h"
#include"../CInputMethodDriver.h"

#include<boost/smart_ptr.hpp>

namespace Maid
{
	class CInputMethodDriverWindows : public IInputMethodDriver, IMessageHook
	{
	public:
		CInputMethodDriverWindows();
		virtual ~CInputMethodDriverWindows();
		void Initialize(HWND hWnd);
		void Release();

		void GetStatus( DWORD* pConversion, DWORD* pSentence) const;

		virtual void Open() ;
		virtual void Close();

		virtual bool IsOpen() const;
		virtual bool IsInput() const;
		virtual int GetConvertPos() const;
		virtual int GetCursorPos() const;


		virtual int GetCandidateCount() const;
		virtual int GetCandidateSelect() const;
		virtual mstring GetCandidateString(int iIndex) const;
		virtual mstring GetCompString() const;

		virtual void SetResultCodeFunction( const RESULTCODEFUNCTION& Function );

		virtual IMessageHook::RETURNCODE OnMessage( CWindowsMessage& Param );

	private:
		void UpdateCandidate();
		
		HWND m_hWnd;

		LPCANDIDATELIST m_pCandidateList;
		boost::shared_array<unt08>	m_pCandidateBuff;

		bool				m_IsInput;
		RESULTCODEFUNCTION	m_Function;	
	};
}

#endif
