#include"CSoundFileStatic.h"
#include"../Storage/Core/CStorageCore.h"
#include"../Auxiliary/CString.h"

#include"../Storage/DefaultFunction/LoadSound.h"
#include"../Auxiliary/Debug/CTrace.h"

namespace Maid
{

//! RXgN^
/*!
 */
CSoundFileStatic::CSoundFileStatic()  
{
}

//! Rs[RXgN^
/*!
 */
CSoundFileStatic::CSoundFileStatic( const CSoundFileStatic& rha )
//	:ISoundFileStatic(rha), m_pObject( rha.m_pObject )	//	RgAEgĂĂȂH 08/02/16
{
	const mstring name = rha.GetFileName();

	if( name.empty() ) { return ; }

	Load( name );
}

//! fXgN^
/*!
 */
CSoundFileStatic::~CSoundFileStatic()
{
	Delete();
}

SPSOUNDOBJECTCORE	CSoundFileStatic::GetSoundObjectCore()
{
	return m_pObject;
}

CSoundFileStatic& CSoundFileStatic::operator = ( const CSoundFileStatic& rha )
{
	Delete();

	const mstring name = rha.GetFileName();

	if( !name.empty() )
	{
		Load( name );
	}

	return *this;
}

void CSoundFileStatic::LoadedDelete( const mstring& FileName )
{
	m_pObject->Delete();
	m_pObject.reset();
}


void CSoundFileStatic::LoadEnd( const SPSTORAGEFUNCTION_RETURNPARAM& pParam,  STATICPCMINFO& info )
{
	LoadSoundStaticReturn* pRet = static_cast<LoadSoundStaticReturn*>(pParam.get());

	info.SamplesPerSec = pRet->SamplesPerSec;
	info.BitsPerSample = pRet->BitsPerSample;
	info.Channels = pRet->Channels;

	m_pObject.reset( new CSoundObjectCore );
	m_pObject->LoadPCMStatic( pRet->pData, pRet->SamplesPerSec, pRet->BitsPerSample, pRet->Channels );

	info.pObject = m_pObject;

}


void CSoundFileStatic::LoadEnd( const STATICPCMINFO& info  )
{
	m_pObject.reset( new CSoundObjectCore );
	m_pObject->LoadPCMStatic( info.pObject );
}



}