/*!	
	@file
	@brief	Xg[TEhIuWFNg
*/

#ifndef CSoundFileStream_h
#define CSoundFileStream_h

#include"../Setup/CompileMode.h"
#include"../template/GlobalPointer.h"
#include"../Storage/CStorageObject.h"
#include"Core/CSoundObjectCore.h"

namespace Maid
{
	//	Xg[t@C̓N[Ȃ̂
	//	StorageObjectTemplate ̌p͂Ȃ
	
	class CSoundFileStream: public GlobalPointer<CStorageCore>
	{
	public:
		CSoundFileStream();
		CSoundFileStream( const CSoundFileStream& rha );
		virtual ~CSoundFileStream();

		void Load( const mstring& FileName );
		void Delete();

		mstring GetFileName() const;
		bool IsNowLoading();

		SPSOUNDOBJECTCORE	GetSoundObjectCore();

	public:
		CSoundFileStream& operator=( const CSoundFileStream& rha );

	private:
		SPSOUNDOBJECTCORE	m_pObject;
		mstring				m_FileName;

		int	m_TickeID;

		enum STATE
		{
			STATE_EMPTY,
			STATE_LOADING,
			STATE_WORKING
		};

		STATE	m_State;
	};
}


#endif
