/*!	
	@file
	@brief	TEhǗNX̃RA
*/

#ifndef CSoundCore_h
#define CSoundCore_h

#include"../../Setup/CompileMode.h"
#include"../../Auxiliary/Thread/CThreadMutex.h"
#include"../../Auxiliary/Thread/CThreadController.h"
#include"../../Auxiliary/CTimer.h"
#include"../../template/GlobalPointer.h"
#include"CSoundMessage.h"
#include"Driver/CSoundCardDriver.h"

namespace Maid
{
	class CSoundCore : public GlobalPointer<CSoundCore>
	{
	public:
		CSoundCore();
		virtual ~CSoundCore();

		void Initialize( const SPSOUNDCARDDRIVER& pDriver, const SPTIMER& pTimer, const ISoundCardDriver::PCMBUFFERFORMAT& Format  );
		void Finalize();

		struct BUFFERSTATUS
		{
			enum
			{
				VOLUME_MIN = 0,
				VOLUME_MAX = 10000,

				PLAYLOOP = -1,
			};

			int	ID;			//	̃IuWFNĝhc

			bool IsPlay;	//	ĐH
			int	PlayCount;	//	Ɖ񃋁[v邩H( -1:[v 0:~ 1`) ݍĐłPɂȂ
			int	Position;	//	݂̈ʒu(~bP)
			float db;		//	݂̔g`̋
		};

		const BUFFERSTATUS* CreateBufferStatus();
			
		void PostMessage( const SPSOUNDMESSAGE& pMessage );

		void SendDeviceCaps();
		mstring GetDeviceCaps();

	private:
		CThreadController	m_Thread;

		SOUNDMESSAGEQUE		m_MessageQue;
		CThreadMutex		m_MessageMutex;		//!<	m_MessageQue ̍XV̓IuWFNg

	private:
		//	ʃXbhĂ΂֐Eo
		unt ThreadFunction( volatile CThreadController::BRIGEDATA& brige );
		void ExecuteMessage( const SPSOUNDMESSAGE& pMessage );

		SPSOUNDCARDDRIVER	m_pDriver;
		SPTIMER				m_pTimer;

		ISoundCardDriver::PCMBUFFERFORMAT m_Format;
		mstring			m_CapsText;

		struct SOUNDINFO
		{
			enum STATE
			{
				STATE_EMPTY,	//	`l󂢂Ă
				STATE_STOP,		//	~
				STATE_PLAY,		//	Đ
				STATE_DELETE,	//	폜
			};

			enum TYPE
			{
				TYPE_STATIC,
				TYPE_STREAM,
				TYPE_MIDI,
			};

			STATE			State;
			TYPE			Type;
			BUFFERSTATUS	Status;		//	Q[ANZXf[^
			SPSOUNDBUFFER	pBuffer;	//	TEhobt@

			bool IsVolumeChanging;	//	{[ύXH

			bool IsVolumeChangeEnd( unt time );
			int CalcVolume( unt time );

			unt BeginTime;
			unt EndTime;
			int BeginVolume;
			int EndVolume;
		};

		SOUNDINFO& FindEmptyInfo();
		void UpdateSoundInfo( SOUNDINFO& Info, unt delta, unt now );

		CThreadMutex				m_SoundInfoMutex;		//!<	m_SoundInfo ̓IuWFNg
		MySTL::vector<SOUNDINFO>	m_SoundInfo;
	};
}


#endif
