#ifndef CSoundMessageImpl1_h
#define CSoundMessageImpl1_h

#include"CSoundMessage.h"

#include"Driver/CSoundCardDriver.h"
#include"../../Storage/DefaultFunction/SoundFileLoader/CSoundDecoder.h"


namespace Maid
{
	namespace SoundMessage
	{
		class LoadPCMStatic : public Base
		{
		public:
			LoadPCMStatic() : Base(LOAD_PCMSTATIC){}

			boost::shared_ptr<MySTL::vector<unt08> >	pData;	//	PCMf[^
			ISoundCardDriver::PCMBUFFERFORMAT Format;
		};

		class LoadPCMStaticClone : public Base
		{
		public:
			LoadPCMStaticClone() : Base(LOAD_PCMSTATICCLONE){}

			int	SrcID;
		};

		class LoadPCMStream : public Base
		{
		public:
			LoadPCMStream() : Base(LOAD_PCMSTREAM){}

			SPSOUNDDECODER	pDecoder;	//	fR[_
		};

		class DeleteBuffer : public Base
		{
		public:
			DeleteBuffer() : Base(DELETEBUFFER){}
		};


		class Play : public Base
		{
		public:
			Play() : Base(PLAY){}
		};

		class Stop : public Base
		{
		public:
			Stop() : Base(STOP){}
		};


		class SetPosition : public Base
		{
		public:
			SetPosition() : Base(SETPOSITION){}
			int	Position;	//	~bœ
		};

		class SetLoopPosition : public Base
		{
		public:
			SetLoopPosition() : Base(SETLOOPPOSITION){}
			int	Position;	//	~bœ
		};

		class SetVolume : public Base
		{
		public:
			SetVolume() : Base(SETVOLUME){}
			int	Volume;
			int	Time;
		};

		class SetPlayCount : public Base
		{
		public:
			SetPlayCount() : Base(SETPLAYCOUNT){}
			int	Count;
		};

	}
}

#endif
