#include"CSoundDecoderOggVorbis.h"
#include"../../Auxiliary/CAssert.h"
#include"../../Auxiliary/CString.h"

// OggVOrbis
//#pragma comment (lib,"ogg_static.lib" )
//#pragma comment (lib,"vorbis_static.lib" )
//#pragma comment (lib,"vorbisfile_static.lib" )


namespace Maid
{
	/*!
	 *	\class	CSoundDecoderOggVorbis CSoundDecoderOggVorbis.h
	 *	\brief	OggVorbis t@CGR[_[
	 */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 *
 */
CSoundDecoderOggVorbis::CSoundDecoderOggVorbis()
{
	m_IsOpen = false;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!
 *
 */
CSoundDecoderOggVorbis::~CSoundDecoderOggVorbis()
{
	Close();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t@C̃[h
/*!
 *	Ȃǂ ISoundDecoder::Open QƂ邱
 */
MRESULT CSoundDecoderOggVorbis::Open( const MySTL::wstring& FileName )
{
	Close();

	if(m_hFile.Open(FileName)!=MRESULT_OK){ return 1; }

	ov_callbacks callbacks = {
		fread_emulation,
		fseek_emulation,
		fclose_emulation,
		ftell_emulation
	};
	// t@COggVorbis`ȁH
	int ret = ov_open_callbacks((LPVOID)this, &m_VorbisFile, NULL, 0, callbacks);
	if(ret!=0){ return 2; }

	// V[NłȂƍ
	if(ov_seekable(&m_VorbisFile)==0){ return 3; }

	m_IsOpen = true;

	return MRESULT_OK;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fR[h
/*!
 *	Ȃǂ ISoundDecoder::Read QƂ邱
 */
uint32 CSoundDecoderOggVorbis::Read( void* pDst, uint32 dwSize )
{
	DEN_ASSERT( !m_IsOpen, "܂JĂ܂" );
	uint32           read = 0;
	OggVorbis_File* pFile = &m_VorbisFile;

	const uint32 len = dwSize*GetBytePerSample();

	while(read<len)
	{
		const long ret = ov_read( pFile, (char*)pDst+read, len-read, 0, 2, 1, NULL);
		DEN_ASSERT( ret==OV_HOLE, "OV_HOLE" );
		DEN_ASSERT( ret==OV_EBADLINK, "OV_EBADLINK" );

		read += ret;
		if( ret==0 ) { break; }
	}

	return read/GetBytePerSample();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fR[hJnʒuړ
/*!
 *	Ȃǂ ISoundDecoder::SetPosition QƂ邱
 */
void CSoundDecoderOggVorbis::SetPosition( sint32 Offset, POSITION ePos )
{
	DEN_ASSERT( !m_IsOpen, "܂JĂ܂" );
	ogg_int64_t pos;

	switch( ePos )
	{
	case ISoundDecoder::BEGIN:	{ pos = Offset; }break;
	case ISoundDecoder::END:	{ pos = GetLength()+Offset; }break;
	case ISoundDecoder::CURRENT:{ pos = GetPosition()+Offset; }break;
	}

	ov_pcm_seek( &m_VorbisFile, pos );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ǂݍ񂾃t@C̉
/*!
 *	Ȃǂ ISoundDecoder::Close QƂ邱
 */
void	CSoundDecoderOggVorbis::Close()
{
	if( m_IsOpen )
	{
		ov_clear(&m_VorbisFile);
		ZERO( &m_VorbisFile, sizeof(m_VorbisFile) );
		m_hFile.Close();
		m_IsOpen = false;
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݂̈ʒu̎擾
/*!
 *	Ȃǂ ISoundDecoder::GetPosition QƂ邱
 */
uint32	CSoundDecoderOggVorbis::GetPosition()		const
{
	DEN_ASSERT( !m_IsOpen, "܂JĂ܂" );
	OggVorbis_File* pFile = const_cast<OggVorbis_File*>(&m_VorbisFile);

	const ogg_int64_t len = ov_pcm_tell( pFile );
	return (sint32)len;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Ro[g̃t@C̒擾iTvPʁj
/*!
 *	Ȃǂ ISoundDecoder::GetLength QƂ邱
 */
uint32	CSoundDecoderOggVorbis::GetLength()			const
{
	DEN_ASSERT( !m_IsOpen, "܂JĂ܂" );
	OggVorbis_File* pFile = const_cast<OggVorbis_File*>(&m_VorbisFile);

	const ogg_int64_t len = ov_pcm_total( pFile, -1 );
	return (sint32)len;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Pb艽Tv邩̎擾
/*!
 *	Ȃǂ ISoundDecoder::GetSamplesPerSec QƂ邱
 */
uint32	CSoundDecoderOggVorbis::GetSamplesPerSec()	const
{
	DEN_ASSERT( !m_IsOpen, "܂JĂ܂" );
	return ov_info(const_cast<OggVorbis_File*>(&m_VorbisFile), -1)->rate;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! `l(mono,stereo )̎擾
/*!
 *	Ȃǂ ISoundDecoder::GetChannels QƂ邱
 */
uint32	CSoundDecoderOggVorbis::GetChannels()		const
{
	DEN_ASSERT( !m_IsOpen, "܂JĂ܂" );
	return ov_info(const_cast<OggVorbis_File*>(&m_VorbisFile), -1)->channels & 0xffff;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! PTvɎgpĂrbgʂ̎擾
/*!
 *	Ȃǂ ISoundDecoder::GetBitsPerBlock QƂ邱
 */
uint32	CSoundDecoderOggVorbis::GetBitsPerBlock()	const
{
	DEN_ASSERT( !m_IsOpen, "܂JĂ܂" );
	return 16;	//	ogg 16Œ
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ̃NXœǂݍ݂o邩ׂ
/*!
 *	Ȃǂ ResourceFile::Test QƂ邱
 */
MRESULT  CSoundDecoderOggVorbis::Test( const MySTL::wstring& FileName )const
{
//	MySTL::wstring s = CString::tolower(CString::GetExtension(FileName));
	if( CString::tolower(CString::GetExtension(FileName))==L"ogg" ) { return MRESULT_OK; }

/*
	CFileRead hFile;
	if( hFile.Open( FileName )!=0 ) { return 1; }

	uint32 HeadCode;
	hFile.Read( &HeadCode, sizeof(HeadCode) );

	if( HeadCode!=Str2Binary32('O','g','g','S') ) { return 2; }
*/
	return 1;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! <stdio.h>  fread() ̃G~[V
/*!
 *	fread ͎ۂɓǂݏoSڂ̐Ԃ܂B\n
 *	̐ count 菬ꍇ́AG[A\n
 *	count ǂݏoOɃt@C̏I[ɒBĂ͂łB\n
 *	size ܂ count  0 ɂƁAfread ֐ 0 Ԃ܂Bobt@̓e͕ς܂B
 *
 *	\param  buffer		[i ]	f[^̊i[ꏊ
 *	\param  size		[i ]	oCgPʂ̍ڃTCY
 *	\param  count		[i ]	ǂݏoő區ڐ
 *	\param  p			[i ]	COggVorbisDecoder* łBLXgĎg
 *
 *	\return ǂݍ񂾃TCYioCgPʁj
 */
size_t CSoundDecoderOggVorbis::fread_emulation(void* buffer, size_t size, size_t count, void *p)
{
	CSoundDecoderOggVorbis* pThis = (CSoundDecoderOggVorbis*)p;
	if(p==NULL)return 0;

	return pThis->m_hFile.Read( buffer, uint32(size*count) );
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! <stdio.h>  fseek() ̃G~[V
/*!
 *	w肳ꂽʒuɃt@C |C^ړ܂
 *
 *	\param  p			[i ]	COggVorbisDecoder* łBLXgĎg
 *	\param  offset		[i ]	origin ̃oCg
 *	\param  origin		[i ]	ʒu
 *
 *
 *	\return ֐̐łO
 *			֐̎słOȊO
 */
int CSoundDecoderOggVorbis::fseek_emulation(void* p, ogg_int64_t offset, int origin)
{
	if(p==NULL)return -1;

	CSoundDecoderOggVorbis* pThis = (CSoundDecoderOggVorbis*)p;
	switch(origin){
	case SEEK_CUR: { pThis->m_hFile.Seek( sint32(offset), IFileRead::CURRENT	); }break;
	case SEEK_END: { pThis->m_hFile.Seek( sint32(offset), IFileRead::END		); }break;
	case SEEK_SET: { pThis->m_hFile.Seek( sint32(offset), IFileRead::BEGIN	); }break;
	default:
		return -1;
	}
	return 0;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! <stdio.h>  fclose() ̃G~[V
/*!
 *	w肵Xg[܂
 *
 *	\param  p			[i ]	COggVorbisDecoder* łBLXgĎg
 *
 *	\return ֐̐łO
 *			֐̎słOȊO
 */
int CSoundDecoderOggVorbis::fclose_emulation(void* p)
{
	if(p==NULL) return(EOF);

	CSoundDecoderOggVorbis* pThis = (CSoundDecoderOggVorbis*)p;
	pThis->m_hFile.Close();

	return 0;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! <stdio.h>  ftell() ̃G~[V
/*!
 *	t@C |C^݈̌ʒu𓾂܂
 *
 *	\param  p			[i ]	COggVorbisDecoder* łBLXgĎg
 *
 *	\return ݂̃t@Cʒu
 */
long CSoundDecoderOggVorbis::ftell_emulation(void* p)
{
	if(p==NULL) return -1;

	CSoundDecoderOggVorbis* pThis = (CSoundDecoderOggVorbis*)p;
	return pThis->m_hFile.GetPosition();
}
}
