/*!	
	@file
	@brief	Xg[WǗNX̃RA
*/

#ifndef CStorageCore_h
#define CStorageCore_h

#include"../../Setup/CompileMode.h"
#include"../../Auxiliary/Thread/CThreadMutex.h"
#include"../../Auxiliary/Thread/CThreadController.h"
#include"../../template/GlobalPointer.h"
#include"../CStorageFunction.h"

#include<map>

namespace Maid
{
	class CStorageCore : public GlobalPointer<CStorageCore>
	{
	public:
		CStorageCore();
		virtual ~CStorageCore();

		void Initialize();
		void Finalize();

		void RegistFunction( int FuncNo, const STORAGEFUNCTION& func );

		int Execute( int FuncNo, const mstring& FileName, const SPSTORAGEFUNCTION_FUNCTIONPARAM& pParam );
		void Cancel( int no );

		bool IsNowLoading( int no );
		SPSTORAGEFUNCTION_RETURNPARAM GetReturnParam(int no);


	private:
		struct POSTMESSAGE
		{
			enum
			{
				CANCEL = -1,	//	FunctionNo==CANCEL ŃLZbZ[W
			};

			int	ReturnCodeID;	//	Xg[WXbhԐM
			int FunctionNo;		//	p[^[֐mn
			mstring	FileName;	//	ꂽt@C
			SPSTORAGEFUNCTION_FUNCTIONPARAM pParam;
		};
		typedef	MySTL::vector<POSTMESSAGE>		POSTMESSAGEQUE;

		struct RETURNCODE
		{
			enum STATE
			{
				STATE_NONE,		//	̗̈͗]Ă
				STATE_LOADING,	//	ǂݍݒ
				STATE_LOADEND,	//	ǂݍ݂I
			};

			STATE							State;	//	bZ[W̏
			SPSTORAGEFUNCTION_RETURNPARAM	pMess;	//	IR[h
		};

		typedef MySTL::map<int,STORAGEFUNCTION> FUNCTIONMAP;



		POSTMESSAGEQUE		m_MessageQue;
		CThreadMutex		m_MessageMutex;		//!<	m_MessageQue ̍XV̓IuWFNg

		FUNCTIONMAP			m_FunctionMap;		//!<	֐Ăf[^
		CThreadMutex		m_FunctionMutex;	//!<	m_FunctionMap ̍XV̓IuWFNg

		MySTL::vector<RETURNCODE>	m_ReturnCode;	//	֐̖߂lĂz
													//	RETURNCODE::State œ̂
													//	CThreadMutex͂Ȃ

		CThreadController	m_Thread;
	private:
		//	ʃXbhĂ΂֐
		unt ThreadFunction( volatile CThreadController::BRIGEDATA& brige );
		int CreateReturnCode();
	};
}

#endif