#include"CBitmapLoader.h"

#include"../../../Graphic/CSurfaceInfo.h"
#include"../../../Graphic/Core/Driver/CPlaneTransiter.h"
#include"../../../Graphic/CSurfaceInfo.h"
#include"../../../Auxiliary/FileIO/CFileRead.h"
#include"../../../Auxiliary/FileIO/CFileReadMemory.h"
#include"../../../Auxiliary/FileIO/CFileWrite.h"
#include"../../../Auxiliary/Debug/CAssert.h"
#include"../../../Auxiliary/Debug/CException.h"
#include"../../../Auxiliary/Debug/CTrace.h"

namespace Maid
{

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! rbg}bveNX`ɓǂݍ
/*!
	@param	FileName	[i ]	t@C
	@param	dst			[i ]	]
 */
void   CBitmapLoader::Load( const mstring& FileName, CTextureBufferMemory& dst )
{
	CFileRead hFile;

	hFile.Open( FileName );

	BITMAPFILEHEADER	BmpFile;
	BITMAPINFOHEADER	BmpInfo;

	{
		//@rbg}bv`̃f[^`FbN
		if(  hFile.Read( &BmpFile, sizeof(BITMAPFILEHEADER) )!=sizeof(BITMAPFILEHEADER) ) { MAID_THROWEXCEPTION(MAIDTEXT("!=sizeof(BITMAPFILEHEADER)")); }

		if( BmpFile.bfType!=0x4D42 ) {  { MAID_THROWEXCEPTION(MAIDTEXT("BmpFile.bfType!=BM")); } }
	}

	SIZE2DI		PlaneSize;
	PIXELFORMAT Format;
	int			Pitch;
	int			CLUTSize=0;

	{
		//@eW
		if( hFile.Read( &BmpInfo, sizeof(BITMAPINFOHEADER) )!=sizeof(BITMAPINFOHEADER) ) { MAID_THROWEXCEPTION(MAIDTEXT("!=sizeof(BITMAPINFOHEADER)")); }

		PlaneSize.w = BmpInfo.biWidth;
		PlaneSize.h = BmpInfo.biHeight;

		switch( BmpInfo.biBitCount )
		{
		case  8: 
			{
				Format = PIXELFORMAT_P08X08R08G08B08I;	
			}break;
		case 24: { Format = PIXELFORMAT_R08G08B08I;			}break;
		case 32: { Format = PIXELFORMAT_A08R08G08B08I;		}break;
		default: { MAID_ASSERT( true, "ʂłȂsNZtH[}bgł " << BmpInfo.biBitCount ); }break;
		}
		
		Pitch = BmpInfo.biWidth * BmpInfo.biBitCount/8;
		Pitch = (Pitch +3)&~3;					//	rbg}bṽsb`͂S̔{ł

		CLUTSize = GetCLUTBPP(Format) / 8 * GetCLUTLength(Format);
	}

	//	]̍쐬
	dst.Create( PlaneSize, Format );
	dst.SetReverseSurface( true );

	{	//	Ԃɓ]ĂB

		//	rbg}bvt@C̓pbgAsNZf[^̏ɕł̂
		//	ēǂł
		ISurfaceBuffer& dst_surf = dst.GetSurface(0);
		SPSURFACEBUFFERINFO pDstInfo;

		CSurfaceBufferLoacker Lock( dst_surf, pDstInfo );

		if( CLUTSize!=0 ) { hFile.Read( pDstInfo->GetCLUT(), CLUTSize ); }

		//	rbg}bv͏㉺]Ă邯ǁA dst.SetReverseSurface( true ) ̂
		//	Src̐擪C Dst ̈ԉ̃Cɓ]Ă

		const int OneLineByte = PlaneSize.w * GetPixelBPP(Format) / 8;
		const int sa = Pitch - OneLineByte;

		for( int y=0; y<PlaneSize.h; ++y )
		{
			hFile.Read( pDstInfo->GetLinePtr(y), OneLineByte );
			hFile.Seek( sa, IFileRead::POSITION_CURRENT );
		}
	}
	//	Ōɖ߂ƕʂɂ
	dst.SetReverseSurface( false );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ǂݍłT[tFXrbg}bvƂĕۑ
/*!
 */
void CBitmapLoader::Save( const mstring& FileName, const CTextureBufferMemory& src )
{
	ISurfaceBuffer& surf = const_cast<CTextureBufferMemory&>(src).GetSurface( 0 );

	Save( FileName, surf );

}

void   CBitmapLoader::Save( const mstring& FileName, ISurfaceBuffer& surf )
{
	SPSURFACEBUFFERINFO pInfo;

	surf.Lock( pInfo );

	const SIZE2DI ImageSize(pInfo->GetWidth(),pInfo->GetHeight());
	const PIXELFORMAT fmt = pInfo->GetPixelFormat();

	const int ImageWidthByte = ImageSize.w * GetPixelBPP(fmt) / 8;
	const int FilePitch = (ImageWidthByte+3)&(~3);
	const int PlaneByte   = FilePitch * ImageSize.h;
	const int PaletteByte = GetCLUTBPP(fmt) / 8 * GetCLUTLength(fmt);


	BITMAPFILEHEADER	BmpFile = {0};
	BITMAPINFOHEADER	BmpInfo = {0};

	BmpFile.bfType = 0x4D42;
	BmpFile.bfSize = sizeof(BmpFile)+sizeof(BmpInfo)+PaletteByte + PlaneByte;
	BmpFile.bfOffBits = sizeof(BmpFile)+sizeof(BmpInfo)+PaletteByte;

	BmpInfo.biSize  = sizeof(BmpInfo);
	BmpInfo.biWidth = ImageSize.w;
	BmpInfo.biHeight = ImageSize.h;
	BmpInfo.biPlanes = 1;
	BmpInfo.biBitCount = GetPixelBPP(fmt);
	BmpInfo.biCompression = BI_RGB;

	CFileWrite hFile;

	hFile.Open( FileName, CFileWrite::OPENOPTION_NEW );
	hFile.Write( &BmpFile, sizeof(BmpFile) );
	hFile.Write( &BmpInfo, sizeof(BmpInfo) );

	if( PaletteByte!=0 )
	{
		hFile.Write( pInfo->GetCLUT(), PaletteByte );
	}

	MySTL::vector<unt08> tmp( FilePitch - ImageWidthByte, 0x00 );


	//	rbg}bv͏㉺t
	for( int y=0; y<ImageSize.h; ++y )
	{
		hFile.Write( pInfo->GetLinePtr((ImageSize.h-1)-y), ImageWidthByte );

		if( !tmp.empty() )
		{
			hFile.Write( &(tmp[0]), (int)tmp.size() );
		}
	}

}

}