#include"SaveImage.h"
#include"CImageFile.h"
#include"../../Graphic/Core/Driver/CPlaneTransiter.h"


namespace Maid
{
	SPSTORAGEFUNCTION_RETURNPARAM SaveImage( const mstring& FileName, const SPSTORAGEFUNCTION_FUNCTIONPARAM& p )
	{
		SaveImageFunction* pParam = static_cast<SaveImageFunction*>(p.get());


		CSurfaceBufferMemory mem;

		mem.Create( pParam->SaveSize, pParam->pSurface->GetPixelFormat() );


		{
			const ISurfaceBuffer& src = *(pParam->pSurface);
			const RECT2DI srcRC( POINT2DI(0,0), src.GetSize() ); 
				  ISurfaceBuffer& dst = mem;
			const RECT2DI dstRC( POINT2DI(0,0), mem.GetSize() ); 


			CPlaneTransiter::BltBiliner( dst, &dstRC, src, &srcRC );
		}

		CBitmapLoader::Save( FileName, mem );

		return SPSTORAGEFUNCTION_RETURNPARAM();
	}
}

