#include"CSoundDecoderOggVorbis.h"
#include"../../../Auxiliary/Debug/CAssert.h"
#include"../../../Auxiliary/CString.h"
#include"../../../Auxiliary/Debug/CTrace.h"



namespace Maid
{
	/*!
	 	@class	CSoundDecoderOggVorbis CSoundDecoderOggVorbis.h
	 	@brief	OggVorbis t@CGR[_[
	 */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 */
CSoundDecoderOggVorbis::CSoundDecoderOggVorbis()
{
	m_IsOpen = false;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!
 *
 */
CSoundDecoderOggVorbis::~CSoundDecoderOggVorbis()
{
	Close();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t@C̃[h
/*!
 	Ȃǂ ISoundDecoder::Open QƂ邱
 */
void CSoundDecoderOggVorbis::Open( const mstring& FileName )
{
	Close();

	m_hFile.Open(FileName);

	ov_callbacks callbacks = {
		fread_emulation,
		fseek_emulation,
		fclose_emulation,
		ftell_emulation
	};
	// t@COggVorbis`ȁH
	int ret = ov_open_callbacks((void*)this, &m_VorbisFile, NULL, 0, callbacks);
	MAID_ASSERT( ret!=0, "oggvorbisłȂ悤ł" );

	// V[NłȂƍ
	ret = ov_seekable(&m_VorbisFile);
	MAID_ASSERT( ret==0, "V[NłȂ悤ł" );


	m_IsOpen = true;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fR[h
/*!
 	Ȃǂ ISoundDecoder::Read QƂ邱
 */
int CSoundDecoderOggVorbis::Read( void* pDst, int dwSize )
{
	MAID_ASSERT( !m_IsOpen, "܂JĂ܂" );
	unt32           read = 0;
	OggVorbis_File* pFile = &m_VorbisFile;

	const unt32 len = dwSize;

	while(read<len)
	{
		const long ret = ov_read( pFile, (char*)pDst+read, len-read, 0, 2, 1, NULL);
		MAID_ASSERT( ret==OV_HOLE, "OV_HOLE" );
		MAID_ASSERT( ret==OV_EBADLINK, "OV_EBADLINK" );

		read += ret;
		if( ret==0 ) { break; }
	}

	return read;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fR[hJnʒuړ
/*!
 *	Ȃǂ ISoundDecoder::SetPosition QƂ邱
 */
void CSoundDecoderOggVorbis::SetPosition( int Offset, POSITION ePos )
{
	MAID_ASSERT( !m_IsOpen, "܂JĂ܂" );
	ogg_int64_t pos;

	const int sample_size = GetBitsPerSamples() / 8 * GetChannels();

	switch( ePos )
	{
	case ISoundDecoder::BEGIN:
		{
			pos = Offset/sample_size;
		}break;
	case ISoundDecoder::END:
		{
			const ogg_int64_t len = ov_pcm_total( &m_VorbisFile, -1 );

			pos = int(len) + (Offset/sample_size); 
		}break;
	case ISoundDecoder::CURRENT:
		{
			pos = (GetPosition()+Offset)/sample_size; 
		}break;
	}

//	MAID_TRACE( "SetPosition " << Offset << " " << ePos );

	ov_pcm_seek( &m_VorbisFile, pos );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ǂݍ񂾃t@C̉
/*!
 *	Ȃǂ ISoundDecoder::Close QƂ邱
 */
void	CSoundDecoderOggVorbis::Close()
{
	if( m_IsOpen )
	{
		ov_clear(&m_VorbisFile);
		ZERO( &m_VorbisFile, sizeof(m_VorbisFile) );
		m_hFile.Close();
		m_IsOpen = false;
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݂̈ʒu̎擾
/*!
 *	Ȃǂ ISoundDecoder::GetPosition QƂ邱
 */
int	CSoundDecoderOggVorbis::GetPosition()		const
{
	MAID_ASSERT( !m_IsOpen, "܂JĂ܂" );
	OggVorbis_File* pFile = const_cast<OggVorbis_File*>(&m_VorbisFile);

	const int sample_size = GetBitsPerSamples() / 8 * GetChannels();

	const ogg_int64_t len = ov_pcm_tell( pFile );
	return (int)len * sample_size;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Ro[g̃t@C̒擾ioCgPʁj
/*!
 *	Ȃǂ ISoundDecoder::GetLength QƂ邱
 */
int	CSoundDecoderOggVorbis::GetLength()			const
{
	MAID_ASSERT( !m_IsOpen, "܂JĂ܂" );
	OggVorbis_File* pFile = const_cast<OggVorbis_File*>(&m_VorbisFile);

	const ogg_int64_t len = ov_pcm_total( pFile, -1 );

	const int bit = GetBitsPerSamples() / 8;
	const int cha = GetChannels();
	const int ret = int(len) * bit * cha;

	return ret;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Pb艽Tv邩̎擾
/*!
 *	Ȃǂ ISoundDecoder::GetSamplesPerSec QƂ邱
 */
int	CSoundDecoderOggVorbis::GetSamplesPerSec()	const
{
	MAID_ASSERT( !m_IsOpen, "܂JĂ܂" );
	const int ret = ov_info(const_cast<OggVorbis_File*>(&m_VorbisFile), -1)->rate;

	return ret;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! `l(mono,stereo )̎擾
/*!
 *	Ȃǂ ISoundDecoder::GetChannels QƂ邱
 */
int	CSoundDecoderOggVorbis::GetChannels()		const
{
	MAID_ASSERT( !m_IsOpen, "܂JĂ܂" );
	const int ret = ov_info(const_cast<OggVorbis_File*>(&m_VorbisFile), -1)->channels & 0xffff;
	return ret;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! PTvɎgpĂrbgʂ̎擾
/*!
 *	Ȃǂ ISoundDecoder::GetBitsPerSamples QƂ邱
 */
int	CSoundDecoderOggVorbis::GetBitsPerSamples()	const
{
	MAID_ASSERT( !m_IsOpen, "܂JĂ܂" );
	return 16;	//	ogg 16Œ
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! <stdio.h>  fread() ̃G~[V
/*!
 *	fread ͎ۂɓǂݏoSڂ̐Ԃ܂B\n
 *	̐ count 菬ꍇ́AG[A\n
 *	count ǂݏoOɃt@C̏I[ɒBĂ͂łB\n
 *	size ܂ count  0 ɂƁAfread ֐ 0 Ԃ܂Bobt@̓e͕ς܂B
 *
 *	\param  buffer		[i ]	f[^̊i[ꏊ
 *	\param  size		[i ]	oCgPʂ̍ڃTCY
 *	\param  count		[i ]	ǂݏoő區ڐ
 *	\param  p			[i ]	COggVorbisDecoder* łBLXgĎg
 *
 *	\return ǂݍ񂾃TCYioCgPʁj
 */
size_t CSoundDecoderOggVorbis::fread_emulation(void* buffer, size_t size, size_t count, void *p)
{

	CSoundDecoderOggVorbis* pThis = (CSoundDecoderOggVorbis*)p;
	if(p==NULL)return 0;

	const int ret = pThis->m_hFile.Read( buffer, unt32(size*count) );

//	MAID_TRACE( MAIDTEXT("fread ") << size << " " << count << " " << ret);

	return ret;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! <stdio.h>  fseek() ̃G~[V
/*!
 *	w肳ꂽʒuɃt@C |C^ړ܂
 *
 *	\param  p			[i ]	COggVorbisDecoder* łBLXgĎg
 *	\param  offset		[i ]	origin ̃oCg
 *	\param  origin		[i ]	ʒu
 *
 *
 *	\return ֐̐łO
 *			֐̎słOȊO
 */
int CSoundDecoderOggVorbis::fseek_emulation(void* p, ogg_int64_t offset, int origin)
{
	if(p==NULL)return -1;

	CSoundDecoderOggVorbis* pThis = (CSoundDecoderOggVorbis*)p;
	switch(origin){
	case SEEK_CUR: { pThis->m_hFile.Seek( int(offset), IFileRead::POSITION_CURRENT	); }break;
	case SEEK_END: { pThis->m_hFile.Seek( int(offset), IFileRead::POSITION_END		); }break;
	case SEEK_SET: { pThis->m_hFile.Seek( int(offset), IFileRead::POSITION_BEGIN	); }break;
	default:
		return -1;
	}

//	MAID_TRACE( MAIDTEXT("fseek") << int(offset) << " " << origin );
	return 0;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! <stdio.h>  fclose() ̃G~[V
/*!
 *	w肵Xg[܂
 *
 *	\param  p			[i ]	COggVorbisDecoder* łBLXgĎg
 *
 *	\return ֐̐łO
 *			֐̎słOȊO
 */
int CSoundDecoderOggVorbis::fclose_emulation(void* p)
{

	if(p==NULL) return(EOF);

	CSoundDecoderOggVorbis* pThis = (CSoundDecoderOggVorbis*)p;
	pThis->m_hFile.Close();

//	MAID_TRACE( MAIDTEXT("fclose") );
	return 0;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! <stdio.h>  ftell() ̃G~[V
/*!
 *	t@C |C^݈̌ʒu𓾂܂
 *
 *	\param  p			[i ]	COggVorbisDecoder* łBLXgĎg
 *
 *	\return ݂̃t@Cʒu
 */
long CSoundDecoderOggVorbis::ftell_emulation(void* p)
{
	if(p==NULL) return -1;

	CSoundDecoderOggVorbis* pThis = (CSoundDecoderOggVorbis*)p;

	const long pos = pThis->m_hFile.GetPosition();

//	MAID_TRACE( MAIDTEXT("ftell ") << pos);
	return pos;
}
}
