/*!
 	@file
 	@brief	COM pX}[g|C^
 */

#ifndef com_ptr_h
#define com_ptr_h

#include"../Setup/CompileMode.h"
#include"../Auxiliary/Debug/CAssert.h"
#include"../Auxiliary/Debug/CException.h"
#include<objbase.h>

namespace Maid
{ 
	/*!
	 *	\brief	COM pX}[g|C^
	\n			QƂȂȂƂ Release() ܂
	 */
	template <class ComObject>
	class com_ptr
	{
	public:
		com_ptr() : m_pInterface(NULL) {}								//!<	RXgN^̂P
		explicit com_ptr( ComObject* pInterface ) : m_pInterface(pInterface){}	//!<	RXgN^̂Q
		com_ptr(const com_ptr<ComObject>& pObject )						//!<	RXgN^̂R
		{
			m_pInterface = pObject.m_pInterface;
			if( !IsNull() )
			{
				m_pInterface->AddRef();
			}
		}

		~com_ptr()	//!<	fXgN^
		{
			reset();
		}

		//! ̃NX̏
		/*!
		 	@param	pInterface	[i ]	VǗbnliftHgłmtkkj
		 */
		void reset( ComObject* pInterface=NULL )	//!<	fXgN^
		{
			if( m_pInterface==pInterface ) { return ; }

			if( !IsNull() )
			{
				m_pInterface->Release();
			}
			m_pInterface = pInterface;
		}

		//! Rs[
		/*!
		 	@param	NewCom	[i ]	Lbnl
		 */
		com_ptr<ComObject>& operator=( com_ptr<ComObject> const & NewCom )
		{
			if( m_pInterface==NewCom.get() ) { return *this; }
			reset();
			m_pInterface = NewCom.get();
			m_pInterface->AddRef();
			return *this;
		}

		bool IsNull() const { return m_pInterface==NULL; }	//!<	ǗĂȂH

		ComObject* get() const 	{ return m_pInterface;	}	//!<	bnl擾
		ComObject* operator->() const //!<	ێĂbnl𓧉ߓIɈ
		{
			MAID_ASSERT( get()==NULL, "܂ݒ肳Ă܂" );
			return get();  
		}		

		//! COMIuWFNg̍쐬
		/*!
		 	@param	ClassID			[i ]	CoCreateInstance() ̃wvQ
		 	@param	pUnknown		[i ]	CoCreateInstance() ̃wvQ
		 	@param	ClassContext	[i ]	CoCreateInstance() ̃wvQ
		 	@param	riid			[i ]	CoCreateInstance() ̃wvQ

			@exception CException COMIuWFNg̍쐬Ɏsꍇ
		 */
		void CoCreateInstance( REFCLSID ClassID, LPUNKNOWN pUnknown, DWORD ClassContext, REFIID riid )
		{
			reset();
			const HRESULT ret = ::CoCreateInstance( ClassID, pUnknown, ClassContext, riid, (void **)&m_pInterface );

			if( FAILED(ret) ) { MAID_THROWEXCEPTION(MAIDTEXT("CoCreateInstance() Ɏs") ); }
		}

		//! COMIuWFNg̍쐬
		/*!
		 	@param	riid		[i ]	QueryInterface() ̃wvQ
		 	@param	pObj		[ o]	쐬ꂽCOMIuWFNg

			@exception CException COMIuWFNg̍쐬Ɏsꍇ
		 */
		template <class QueryObject>
		void QueryInterface( REFIID riid, com_ptr<QueryObject>& pObj )
		{
			MAID_ASSERT( get()==NULL, "܂ݒ肳Ă܂" );

			QueryObject* p;
			const HRESULT ret = m_pInterface->QueryInterface( riid, (void **)&p );
			if( FAILED(ret) ) { MAID_THROWEXCEPTION(MAIDTEXT("QueryInterface() Ɏs") ); }

			pObj.reset(p);
		}

	private:
		ComObject*	m_pInterface;
	};

	template<class ComObject> 
	inline bool operator==(const com_ptr<ComObject>  & lhs, const com_ptr<ComObject>  & rhs)
	{
		return lhs.get() == rhs.get();
	}

	template<class ComObject> 
	inline bool operator!=(const com_ptr<ComObject>  & lhs, const com_ptr<ComObject>  & rhs)
	{
		return !(lhs == rhs);
	}
}
#endif
