#include"../../Maid/FrameWork/Windows/CSingleWindowAppWindows.h"

#include"../../Maid/Graphic/CGraphic.h"

#include"../../Maid/Graphic/CPixelShader.h"
#include"../../Maid/Graphic/CVertexShader.h"
#include"../../Maid/Graphic/CVertex.h"
#include"../../Maid/Graphic/CTextureFile.h"

#include"../../Maid/Graphic/CCustomVertexTemplate.h"

#include"../../Maid/Storage/CStorage.h"

#include"../../Maid/Auxiliary/CString.h"

using namespace Maid;


class CApp : public IGameThread
{
protected:
	void OnLocalSetup( APPCONFIG& conf )
	{

	}

	void OnLocalEnd()
	{

	}

	void OnLocalBegin( const BEGINPARAM& param )
	{
		{
			CGraphic::SCREENMODE m;

			m.Mode = CGraphic::SCREENMODE::TYPE_WINDOW;
			m.Size = SIZE2DI(800,600);
			m.RefreshRate = 0;
			m.IsSoftTnL = false;
			m.IsWaitVSync = true;
			m.IsAspectLock = false;

			m_Graphic.Initialize( m, param.pFontDriver, param.pInfo );
		}
		{
			m_Storage.Initialize( );
		}


		tex1.Load( MAIDTEXT("sample.bmp") );
		tex2.Load( MAIDTEXT("sample.png") );
		tex3.Load( MAIDTEXT("sample.jpg") );
		tex4.Load( MAIDTEXT("sample.bmp") );	//	łɓǂݍł̂ŃLbV

		Rot = 0;
	}

	void OnLocalLoop()
	{
		//	ŕ`施߂o
		m_Graphic.ClearRenderTargetColor( COLOR_A08R08G08B08I(0xFF,0x00,0x00,0x80) );

		SIZE2DI texsize(0,0);

		if( !tex1.IsNowLoading() )
		{	//	ǂݍ݂IĂ\
			texsize = tex1.GetSize();

			m_Graphic.SetBltState( CGraphic::BLTSTATE_NORMAL );
			const RECT2DI rc( POINT2DI(0,0), tex1.GetSize() );
			const POINT2DI off(rc.w/2,rc.h/2);

			//	ʂ̕`
			m_Graphic.Blt( POINT2DF(400,300), tex1, rc, off );
		}

		if( !tex2.IsNowLoading() )
		{
			const RECT2DI rc( POINT2DI(0,0), tex2.GetSize() );
			const POINT2DI off(rc.w/2,rc.h/2);
			//	g̕` xt
			m_Graphic.BltS( POINT2DF(400,300), tex2, rc, SIZE2DF(1.5f,1.2f), off, ALPHA(50) );
		}
		
		Rot += DEGtoRAD(5);

		if( !tex3.IsNowLoading() )
		{
			const RECT2DI rc( POINT2DI(0,0), tex3.GetSize() );
			const POINT2DI off(rc.w/2,rc.h/2);
			//	]̕` Zł
			m_Graphic.SetBltState( CGraphic::BLTSTATE_ADD );
			m_Graphic.BltR( POINT2DF(400,300), tex3, rc, Rot, VECTOR3DF(0,0,1), off );
		}

		if( !tex4.IsNowLoading() )
		{
			const RECT2DI rc( POINT2DI(0,0), tex4.GetSize() );
			const POINT2DI off(rc.w/2,rc.h/2);
			//	g]
			m_Graphic.BltSR( POINT2DF(400,300), tex4, rc, SIZE2DF(0.5f,0.2f), -Rot, VECTOR3DF(0,0,1), off );
		}

		{	//	eLXg̕\
			char buf[256];
			sprintf( buf, "eNX`TCY:%dx%d", texsize.w, texsize.h );
			SPFONT pFont = m_Graphic.CreateFont( 0, SIZE2DI(16,32), true, false, false );
			m_Graphic.BltText( POINT2DF(0,0), pFont, COLOR_A08R08G08B08I(0xFF,0xFF,0xFF,0xFF), CString::ConvertSJIStoMAID(buf) );
		}

		//	̃t[
		OnNextFrame(m_Graphic);
		::Sleep(10);
	}


private:
	CGraphic		m_Graphic;
	CStorage	m_Storage;
	CTextureFile	tex1;
	CTextureFile	tex2;
	CTextureFile	tex3;
	CTextureFile	tex4;

	float	Rot;

};


int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow )
{
	CSingleWindowAppWindows capp( SPGAMETHREAD( new CApp ) );
	return capp.Run( hInstance, hPrevInstance, lpCmdLine, nCmdShow );
}