#include"../../Maid/FrameWork/Windows/CSingleWindowAppWindows.h"

#include"../../Maid/Graphic/CGraphic.h"

#include"../../Maid/Graphic/CPixelShader.h"
#include"../../Maid/Graphic/CVertexShader.h"
#include"../../Maid/Graphic/CVertex.h"
#include"../../Maid/Graphic/CTextureFile.h"

#include"../../Maid/Graphic/CCustomVertexTemplate.h"

#include"../../Maid/Storage/CStorage.h"

#include"../../Maid/Auxiliary/CString.h"

using namespace Maid;


class CApp : public IGameThread
{
protected:
	void OnLocalSetup( APPCONFIG& conf )
	{

	}

	void OnLocalEnd()
	{

	}

	void OnLocalBegin( const BEGINPARAM& param )
	{
		{
			CGraphic::SCREENMODE m;

			m.Mode = CGraphic::SCREENMODE::TYPE_WINDOW;
			m.Size = SIZE2DI(800,600);
			m.RefreshRate = 0;
			m.IsSoftTnL = false;
			m.IsWaitVSync = true;
			m.IsAspectLock = false;

			m_Graphic.Initialize( m, param.pFontDriver, param.pInfo );
		}
		{
			m_Storage.Initialize( );
		}

		//	RcłQcۂƂ\Ă݂

		//	܂̓J̐ݒ
		//	(x,y) (0,0,0) , (800,600,0) E̔zuɂȂ
		camera.Set2DPosition( 800, 600, 0.01f, 1000.0f );


		//	eNX`̃[h
		tex.Load( MAIDTEXT("sample.bmp") );
	}

	void OnLocalLoop()
	{
		m_Graphic.ClearRenderTargetColor( COLOR_R08G08B08I(0x00,0x00,0x80) );
		m_Graphic.ClearRenderTargetZ( 1 );

		m_Graphic.SetCamera( camera );

		if( !tex.IsNowLoading() )
		{
			const RECT2DI rc( POINT2DI(0,0), tex.GetSize() );
			m_Graphic.Blt3D( POINT3DF(400,300,0), tex, rc );
		}

		//	̃t[
		OnNextFrame(m_Graphic);
		::Sleep(10);
	}

private:
	CGraphic		m_Graphic;
	CStorage	m_Storage;
	CCamera camera;
	CTextureFile tex;
};


int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow )
{
	CSingleWindowAppWindows capp( SPGAMETHREAD( new CApp ) );
	return capp.Run( hInstance, hPrevInstance, lpCmdLine, nCmdShow );
}