#ifndef CSetupConfig_h
#define CSetupConfig_h


/*!
 *	\file
 *	\brief	Nɐݒ肳ĂɃANZXłNX
 */


#include"../../Maid/Setup/CompileMode.h"
#include"../../Maid/Auxiliary/XML/CXMLReader.h"

#include<string>
#include<vector>
#include<map>

class CSetupConfig
{
public:
	void Initialize( const Maid::mstring& FilePath );

	Maid::mstring GetMutexName()const;
	Maid::mstring GetWindowCaption()const;
	Maid::mstring GetGUID()const;
	Maid::mstring GetUninstallTittle()const;
	Maid::mstring GetTargetRegistry()const;
	Maid::mstring GetDefaultTarget()const;

	Maid::mstring GetProgramFilesFolder()const;
	Maid::mstring GetWindowsFolder()const;
	Maid::mstring GetStartMenuFolder()const;
	Maid::mstring GetDesktopFolder()const;


	struct INSTALLTYPE
	{
		struct COPYFILE
		{
			int DiskNo;
			Maid::mstring SrcPath;
			Maid::mstring DstPath;
			Maid::mstring MD5;
		};

		struct SHORTCUT
		{
			Maid::mstring TargetObject;
			Maid::mstring CreatePath;
			Maid::mstring Parameters;
		};

		Maid::mstring InstallTypeName;
		Maid::mstring InstallTypeComment;

		MySTL::vector<COPYFILE>	CopyFileList;
		MySTL::vector<SHORTCUT>	ShortcutList;

	};

	INSTALLTYPE GetInstallType( int no )const;
	int			GetInstallTypeCount()const;

	struct EXECUTEINFO
	{
		Maid::mstring CheckComment;
		Maid::mstring ExecutePath;
		Maid::mstring Parameters;
	};

	EXECUTEINFO GetExecuteInfo()const;


	void SetInstallFolder( const Maid::mstring& dir );
	Maid::mstring GetInstallFolder()const;



private:
	Maid::mstring ConvertText( const Maid::mstring& t );
	void ConvertTextThis( Maid::mstring& t );
	void AddConvertTable( const Maid::mstring& index, const Maid::mstring& data );

	void ReadLastExec( Maid::CXMLReader& reader );
	void ReadInstall( Maid::CXMLReader& reader );
	void ReadCopyFile( Maid::CXMLReader& reader, INSTALLTYPE::COPYFILE& dat );
	void ReadShortcut( Maid::CXMLReader& reader, INSTALLTYPE::SHORTCUT& dat );
private:
	Maid::mstring	m_MutexName;
	Maid::mstring	m_WindowCaption;
	Maid::mstring	m_GUID;
	Maid::mstring	m_UninstallTittle;
	Maid::mstring	m_TargetRegistry;
	Maid::mstring	m_DefaultTarget;

	MySTL::vector<INSTALLTYPE>	m_InstallType;
	EXECUTEINFO	m_ExecuteInfo;

	typedef MySTL::map<Maid::mstring,Maid::mstring> CANVERTTABLE;
	CANVERTTABLE	m_ConvertTable;
	Maid::mstring	m_InstallFolder;
};

#endif
