# coding: UTF-8

require 'mailutils/mail_processor'

#=摜ɊւeXg[eBeB
#
# ŏ̒:: gDC[
# |Wg:: $Id: image_testutils.rb 491 2012-01-26 23:51:17Z toy_dev $
# 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
# CZX:: CPL(Common Public Licence)
class ImageTestUtils

	def self.nearly_identical?(image1, image2, color_range = 2000, nearly_idential_percent = 70)
		return false unless image1.columns == image2.columns && image1.rows == image2.rows

		pixels1 = image1.get_pixels(0, 0, image1.columns, image1.rows)
		pixels2 = image2.get_pixels(0, 0, image2.columns, image2.rows)

		return false unless pixels1.size == pixels2.size

		count = 0
		pixels1.each_with_index do |p, i|
			if (pixels1[i].red - color_range) <= pixels2[i].red && pixels2[i].red <= (pixels1[i].red + color_range) then
				if (pixels1[i].green - color_range) <= pixels2[i].green && pixels2[i].green <= (pixels1[i].green + color_range) then
					if (pixels1[i].blue - color_range) <= pixels2[i].blue && pixels2[i].blue <= (pixels1[i].blue + color_range) then
						count = count + 1
					end
				end
			end
		end

		return (100 * count / pixels1.size) >= nearly_idential_percent
	end

end
