#!ruby
# coding: UTF-8

#=テスト結果のサマリーを出力する CGI スクリプト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: view_testresult.cgi 376 2011-11-26 02:59:07Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)

ROOT_PATH = File.dirname(File.expand_path(__FILE__))
$:.unshift(ROOT_PATH + "/")

require 'cgi'

require 'minitestresult'
require 'view_testresult_conf'

result = MiniTestResult.new(TESTRESULT_FILE_STDOUT, 'UTF-8', TESTRESULT_FILE_ENCODING)

# 結果を html で出力する
cgi = CGI.new("html4")

def output_summary(cgi, result)
	cgi.out() do
		cgi.html() do
			cgi.head() do
				cgi.title{HTML_TITLE} +
				"<META http-equiv='Content-Type' content='text/html; charset=UTF-8' />" +
				((CSS_URL != nil) ? "<LINK rel='stylesheet' href='#{CSS_URL}' type='text/css' />" : '')
			end +
			cgi.body() do
				body = "<h1>#{HTML_TITLE}</h1>"

				if result.valid? then
					# 総合を出力する
					body << "<h2>#{RESULT_TITLE}</h2>"

					body << %Q!<table id="minitest_cibase_result_table">!
					body << "<tr>"
					if result.success?(nil, nil, nil) then
						body << %Q!<td class="successed">#{RESULT_LABEL_SUCCESED}</td>!
					else
						body << %Q!<td class="failed">#{RESULT_LABEL_FAILED}</td>!
					end
					body << "</tr>"
					body << "</table>"

					# 時間を出力する
					body << "<h2>#{TIME_TITLE}</h2>"

					body << %Q!<table id="minitest_cibase_time_table">!
					body << "<tr><th>#{TIME_LABEL_TEST_START_TIME }</th><td>#{(result.start_time  != nil ? result.start_time  : TIME_LABEL_UNKNOWN)}</th></tr>"
					body << "<tr><th>#{TIME_LABEL_TEST_FINISH_TIME}</th><td>#{(result.finish_time != nil ? result.finish_time : TIME_LABEL_UNKNOWN)}</th></tr>"
					body << "</table>"

					# 概要を出力する
					body << "<h2>#{SUMMARY_TITLE}</h2>"

					body << %Q!<table id="minitest_cibase_summary_table">!
					body << "<tr>"
					body << "<th>#{TABLE_COLUMN_LABEL_TEST_SOURCE}</th>"
					body << "<th>#{TABLE_COLUMN_LABEL_TEST_CLASS}</th>"
					body << "<th>#{TABLE_COLUMN_LABEL_SUCCESSED_COUNT}</th>"
					body << "<th>#{TABLE_COLUMN_LABEL_FAILED_COUNT}</th>"
					body << "</tr>"
					result.each_sources do |test_source|
						class_index = 0
						result.each_classes(test_source) do |test_cls|
							body << "<tr>"
							if class_index == 0 then
								css_class = result.success?(test_source, nil, nil) ? "successed" : "failed"
								body << %Q!<td class="#{css_class}" rowspan="#{result.size_of_classes(test_source)}">#{test_source}</td>!
							end
							css_class = result.success?(test_source, test_cls, nil) ? "successed" : "failed"
							body << %Q!<td class="#{css_class}">#{test_cls}</td>!
							body << %Q!<td class="#{css_class}">#{result.success_count_of_class(test_source, test_cls)}</td>!
							body << %Q!<td class="#{css_class}">#{result.fail_count_of_class(test_source, test_cls)}</td>!
							body << "<tr>"

							class_index = class_index + 1
						end
					end
					body << "</table>"

					# 詳細を出力する
					body << "<h2>#{DETAIL_TITLE}</h2>"

					body << %Q!<table id="minitest_cibase_detail_table">!
					body << "<tr>"
					body << "<th>#{TABLE_COLUMN_LABEL_TEST_SOURCE}</th>"
					body << "<th>#{TABLE_COLUMN_LABEL_TEST_CLASS}</th>"
					body << "<th>#{TABLE_COLUMN_LABEL_TEST_METHOD}</th>"
					body << "<th>#{TABLE_COLUMN_LABEL_SEC}</th>"
					body << "<th>#{TABLE_COLUMN_LABEL_RESULT}</th>"
					body << "<th>#{TABLE_COLUMN_LABEL_STDOUT}</th>"
					body << "<th>#{TABLE_COLUMN_LABEL_ERROR_REPORT}</th>"
					body << "</tr>"

					result.each_sources do |test_source|
						class_index = 0
						result.each_classes(test_source) do |test_cls|
							method_index = 0
							result.each_methods(test_source, test_cls) do |test_method|
								body << "<tr>"
								if class_index == 0 && method_index == 0 then
									css_class = result.success?(test_source, nil, nil) ? "successed" : "failed"
									body << %Q!<td class="#{css_class}" rowspan="#{result.size_of_methods(test_source, nil)}">#{test_source}</td>!
								end

								if method_index == 0 then
									css_class = result.success?(test_source, test_cls, nil) ? "successed" : "failed"
									body << %Q!<td class="#{css_class}" rowspan='#{result.size_of_methods(test_source, test_cls)}'>#{test_cls}</td>!
								end

								body << "<td>#{test_method}</td>"
								body << "<td>#{result.sec(test_source, test_cls, test_method)}</td>"

								if result.success?(test_source, test_cls, test_method) then
									body << %Q!<td class="successed">#{RESULT_LABEL_SUCCESED}</td>!
								else
									body << %Q!<td class="failed">#{RESULT_LABEL_FAILED}</td>!
								end

								if result.has_stdout?(test_source, test_cls, test_method) then
									body << %Q!<td><a href="#{cgi.path_info}?cmd=stdout&test_source=#{test_source}&test_cls=#{test_cls}&test_method=#{test_method}&">#{STDOUT_LABEL}</a></td>!
								else
									body << "<td></td>"
								end

								if result.has_error_report?(test_source, test_cls, test_method) then
									body << %Q!<td><a href="#{cgi.path_info}?cmd=error_report&test_source=#{test_source}&test_cls=#{test_cls}&test_method=#{test_method}&">#{ERROR_REPORT_LABEL}</a></td>!
								else
									body << "<td></td>"
								end
								body << "</tr>"

								method_index = method_index + 1
							end
							class_index = class_index + 1
						end
					end
					body << "</table>"
				else
					# 不正であることを出力する
					body << "<div>#{LABEL_MINI_TEST_RESULT_INVALID}</div>"
				end

				body
			end
		end
	end
end

def output_stdout(cgi, result)
	test_source = cgi['test_source']
	test_cls = cgi['test_cls']
	test_method = cgi['test_method']

	cgi.out() do
		cgi.html() do
			cgi.head() do
				cgi.title{HTML_TITLE + ' - ' + HTML_STDOUT_TITLE + "[#{test_cls}##{test_method}]"} +
				"<META http-equiv='Content-Type' content='text/html; charset=UTF-8' />" +
				((CSS_URL != nil) ? "<LINK rel='stylesheet' href='#{CSS_URL}' type='text/css' />" : '')
			end +
			cgi.body() do
				body = "<h1>#{HTML_STDOUT_TITLE}</h1>"

				if result.valid? then
					body << "<pre>#{CGI.escapeHTML(result.stdout(test_source, test_cls, test_method))}</pre>"
				else
					# 不正であることを出力する
					body << "<div>#{LABEL_MINI_TEST_RESULT_INVALID}</div>"
				end

				body
			end
		end
	end
end

def output_error_report(cgi, result)
	test_source = cgi['test_source']
	test_cls = cgi['test_cls']
	test_method = cgi['test_method']

	cgi.out() do
		cgi.html() do
			cgi.head() do
				cgi.title{HTML_TITLE + ' - ' + HTML_ERROR_REPORT_TITLE + "[#{test_cls}##{test_method}]"} +
				"<META http-equiv='Content-Type' content='text/html; charset=UTF-8' />" +
				((CSS_URL != nil) ? "<LINK rel='stylesheet' href='#{CSS_URL}' type='text/css' />" : '')
			end +
			cgi.body() do
				body = "<h1>#{HTML_ERROR_REPORT_TITLE}</h1>"

				if result.valid? then
					error_line = result.error_line(test_source, test_cls, test_method)
					body << "<pre>#{CGI.escapeHTML(result.error_report(test_source, test_cls, test_method))}</pre>"
					if error_line != nil then
						body << "<hr />"
						body << "<pre>#{CGI.escapeHTML(error_line)}</pre>"
						body << "<hr />"
						if error_line =~ /^(.+):([0-9]+)$/ then 
							error_source_filename = $1
							error_source_line = $2.to_i

							body << %Q!<table id="minitest_cibase_error_source_table">!
							line_number = 1
							open(error_source_filename, 'rb') do |file|
								from_encoding = nil
								while line = file.gets
									line = line.chomp

									if line =~ /^#.*?coding:\s*(.+?)\s*$/ then
										from_encoding = $1
									end
									if from_encoding != nil then
										line = line.encode('UTF-8', from_encoding)
									end

									if line_number > error_source_line - 10 && line_number < error_source_line + 10 then
										body << "<tr>"
										css_class = error_source_line == line_number ? %Q! class="error_line"! : ""
										body << "<td#{css_class}>#{line_number}</td>"
										if line == "" then
											body << "<td#{css_class}><pre> </pre></td>"
										else
											body << "<td#{css_class}><pre>#{CGI.escapeHTML(line)}</pre></td>"
										end
									end

									line_number = line_number + 1
								end
							end
							body << "</table>"
						end
					end
				else
					# 不正であることを出力する
					body << "<div>#{LABEL_MINI_TEST_RESULT_INVALID}</div>"
				end

				body
			end
		end
	end
end

begin
	case cgi['cmd']
	when 'stdout'
		output_stdout(cgi, result)
	when 'error_report'
		output_error_report(cgi, result)
	else
		output_summary(cgi, result)
	end
rescue Exception => e
	puts 'Content-type: text/plain'
	puts
	puts e.message
	puts e.backtrace
end
