# coding: UTF-8

require 'plugin/command/adapter/mail/lib/standard_command_adapter4mail'

#=ブログ記事削除コマンドアダプタープラグイン（メール用）
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: delete.rb 864 2012-10-23 22:36:39Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Delete_CommandAdapterPlugin4Mail < Standard_CommandAdapterPlugin4Mail

	attr_writer :mail_parser

	def create_request(command, mail)
		subject_parsed_result = @mail_parser.parse_subject(mail.escaped_prefix_subject)
		param = subject_parsed_result ? subject_parsed_result[1] : nil

		content = @mail_parser.escaped_prefix_content(mail.content, 'postid\.')
		(header, content, contents) = @mail_parser.parse_content(content, command.header_alias())
		param = header['blogid'] if header.has_key?('blogid')

		return Mail2WeblogRequest.new(
			:source => mail.from_address.address,
			:param => param,
			:header => header)
	end

	def create_response(command, request, response)
		return response.success ? create_success_response(command, request, response) : create_failure_response(command, request, response)
	end

	def create_success_response(command, request, response)
content = <<"END_CONTENT"
postid.#{response[:postid]}

ブログ記事の削除に成功しました。
#{make_exception_contents(response)}
END_CONTENT

		response.notices.push(Mail2WeblogResponseNotice.new(
			:destination => request.source,
			:type => 'deleted',
			:param => request.param,
			:content => content
		))
		return response
	end

	def create_failure_response(command, request, response)
content = <<"END_CONTENT"
ブログ記事の削除に失敗しました。
#{make_exception_contents(response)}
END_CONTENT

		response.notices.push(Mail2WeblogResponseNotice.new(
			:destination => request.source,
			:type => 'error',
			:param => request.param,
			:content => content
		))
		return response
	end

end
