# coding: UTF-8

if $0 == __FILE__ then
	ROOT_PATH = File.dirname(File.expand_path(__FILE__))

	$:.unshift(ROOT_PATH + "/../../../../")
	$:.unshift(ROOT_PATH + "/../../../../../main/")
	$:.unshift(ROOT_PATH + "/../../../../../main/lib/")

	# mail2weblog のルートパスを設定する
	M2W_ROOT_PATH = ROOT_PATH + "/../../../../../main/"

	require 'm2w_configurator'
	require 'minitest/autorun'
end

#=metaWeblog API を使った標準のウェブログプラグインのテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_meta_weblog.rb 830 2012-10-02 16:04:39Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestMetaWeblog < MiniTest::Unit::TestCase

	def test_parse_date
		weblog = MetaWeblog_WeblogPlugin.new

		errors = []
		warnings = []
		result = weblog.parse_date(nil, nil, errors, warnings)
		assert_nil result
		assert_equal 0, errors.size
		assert_equal 0, warnings.size

		errors = []
		warnings = []
		result = weblog.parse_date('abcdef', nil, errors, warnings)
		if RUBY_VERSION < '1.9.0' then
			assert result != nil
			assert_equal 0, errors.size
			assert_equal 0, warnings.size
		else
			assert_nil result
			assert_equal 0, errors.size
			assert_equal 1, warnings.size
		end

		errors = []
		warnings = []
		result = weblog.parse_date('11/13', nil, errors, warnings)
		assert result != nil
		assert_equal 0, errors.size
		assert_equal 0, warnings.size

		errors = []
		warnings = []
		result = weblog.parse_date('11/13 13:30', nil, errors, warnings)
		assert result != nil
		assert_equal 0, errors.size
		assert_equal 0, warnings.size

		errors = []
		warnings = []
		result = weblog.parse_date('2011/11/13 13:30', nil, errors, warnings)
		assert result != nil
		assert_equal 0, errors.size
		assert_equal 0, warnings.size

		errors = []
		warnings = []
		result = weblog.parse_date('11/13 13:30:15', nil, errors, warnings)
		assert result != nil
		assert_equal 0, errors.size
		assert_equal 0, warnings.size

		errors = []
		warnings = []
		result = weblog.parse_date('2011/11/13 13:30:15', nil, errors, warnings)
		assert result != nil
		assert_equal 0, errors.size
		assert_equal 0, warnings.size

		errors = []
		warnings = []
		result = weblog.parse_date('2011/11/13 13:30:15+09:00', nil, errors, warnings)
		assert result != nil
		assert_equal 0, errors.size
		assert_equal 0, warnings.size

		errors = []
		warnings = []
		result = weblog.parse_date(nil, Time.now, errors, warnings)
		assert result != nil
		assert_equal 0, errors.size
		assert_equal 0, warnings.size
	end

end
