# coding: UTF-8

require 'plugin/weblog/movable_type/movable_type'
require 'plugin/weblog/fc2/fc2_formatter'
require 'plugin/weblog/fc2/fc2_edit'
require 'plugin/weblog/fc2/fc2_post'

M2W_WEBLOG_FC2_ENDPOINT = 'http://blog.fc2.com/xmlrpc.php'

M2W_WEBLOG_FC2_DEFAULT_ENCODING = 'UTF-8'
M2W_WEBLOG_FC2_ATTACHMENT_ROOT_PATH = 'attrs'
M2W_WEBLOG_FC2_THUMBNAIL_ROOT_PATH = 'thumbs'
M2W_WEBLOG_FC2_XMLRPC_ENCODING = 'UTF-8'
M2W_WEBLOG_FC2_XMLRPC_ENCODING4BLOGGER = 'EUC-JP'

#=FC2 ブログのためのウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: fc2.rb 581 2012-03-11 03:45:16Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Fc2_WeblogPlugin < MovableType_WeblogPlugin

	def initialize(endpoint = M2W_WEBLOG_FC2_ENDPOINT, username = M2W_WEBLOG_USERNAME, password = M2W_WEBLOG_PASSWORD, encoding = M2W_WEBLOG_FC2_DEFAULT_ENCODING, attachment_root_path = M2W_WEBLOG_FC2_ATTACHMENT_ROOT_PATH, thumbnail_root_path = M2W_WEBLOG_FC2_THUMBNAIL_ROOT_PATH)
		super
	end

	def header_alias_for_post
		return {
			'cat' => M2W_WEBLOG_MT_CATEGORIES,
			'cats' => M2W_WEBLOG_MT_CATEGORIES,
		}
	end

	def client
		result = super
		result.set_parser(XMLRPCParser.new(M2W_WEBLOG_FC2_XMLRPC_ENCODING))
		return result
	end

	def formatter
		return Fc2Formatter.new(@plugin_manager)
	end

	# 添付ファイルのデフォルトのパスを取得します。
	def get_attachment_default_filepath(postid, dateCreated, attachment_index, attachment_filename)
		return "#{@attachment_root_path}#{postid}_#{attachment_index}#{File.extname(attachment_filename)}"
	end

	# サムネイルのデフォルトのパスを取得します。
	def get_thumbnail_default_filepath(postid, dateCreated, attachment_index, attachment_filename)
		return "#{@thumbnail_root_path}#{postid}_#{attachment_index}#{File.extname(attachment_filename)}"
	end

	def get_blogs4trackback(client, blogid)
		client.set_parser(XMLRPCParser.new(M2W_WEBLOG_FC2_XMLRPC_ENCODING4BLOGGER))
		blogs = Blogger.new(client, @username, @password, M2W_SYSTEM_INNER_ENCODING).get_users_blogs()
		client.set_parser(XMLRPCParser.new(M2W_WEBLOG_FC2_XMLRPC_ENCODING))
		return blogs
	end

	# ブログ記事投稿用のプラグインを取得します。
	def get_post_plugin()
		return Fc2Post_WeblogPlugin.new(self)
	end

	# ブログ記事編集用のプラグインを取得します。
	def get_edit_plugin()
		return Fc2Edit_WeblogPlugin.new(self)
	end

end
