# coding: UTF-8

ROOT_PATH = File.dirname(File.expand_path(__FILE__))

$:.unshift(ROOT_PATH + "/")
$:.unshift(ROOT_PATH + "/../../")
$:.unshift(ROOT_PATH + "/../../../main/")
$:.unshift(ROOT_PATH + "/../../../main/lib")

# mail2weblog のルートパスを設定する
M2W_ROOT_PATH = ROOT_PATH + "/../../../main/"

require 'm2w_configurator'
require 'm2w_mail_parser'
require 'm2w_mail_sender'
require 'm2w_plugin_manager'
require 'mailutils/mail_processor'
require 'testutils/accessor'
require 'testutils/mail_testutils'
require 'testutils/weblog_testutils'

require 'conf/setting'

require 'minitest/unit'

MiniTest::Unit.autorun

#=ブログ記事取得コマンドプラグインのテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_get_plugin.rb 616 2012-03-17 00:16:19Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestGetCommandPlugin < MiniTest::Unit::TestCase

	if REAL_M2W_TEST && REAL_GET_TEST then
		def setup
			@mail_parser = Mail2WeblogMailParser.new(
				M2W_SUBJECT_HEADER,
				M2W_SUBJECT_SEPARATOR_REGEX,
				{})

			@mail_sender = Mail2WeblogMailSender.new(
				SENDER_SMTP_SERVER_ADDRESS,
				SENDER_SMTP_SERVER_PORT,
				SENDER_SMTP_SECURITY_TYPE,
				SENDER_SMTP_SERVER_USER,
				SENDER_SMTP_SERVER_PASSWORD,
				SENDER_POP3_SERVER_ADDRESS,
				SENDER_POP3_SERVER_PORT,
				SENDER_POP3_SERVER_USER,
				SENDER_POP3_SERVER_PASSWORD,
				M2W_SUBJECT_HEADER,
				M2W_SUBJECT_SEPARATOR,
				MailProcessor.parse_mail_address(M2W_REPLY_ADDRESS))

			@mail_testutils = MailTestUtils.new(
				SENDER_SMTP_SERVER_ADDRESS,
				SENDER_SMTP_SERVER_PORT,
				SENDER_SMTP_SECURITY_TYPE,
				SENDER_SMTP_SERVER_USER,
				SENDER_SMTP_SERVER_PASSWORD,
				SENDER_POP3_SERVER_ADDRESS,
				SENDER_POP3_SERVER_PORT,
				SENDER_POP3_SERVER_USER,
				SENDER_POP3_SERVER_PASSWORD,
				M2W_SYSTEM_INNER_ENCODING)
			@mail_testutils.delete_all()

			@weblog_testutils = WeblogTestUtils.new(
				M2W_WEBLOG_EXTENSION,
				@mail_parser,
				@mail_sender,
				Mail2WeblogPluginManager.new(),
				@mail_testutils,
				SENDER_MAILADDRESS,
				RECEIVER_MAILADDRESS)
		end

		# リアル投稿テストです。
		# 本テストは、設定（conf/setting.rb）に依存します。
		def test_simple
			M2W_LOGGER.debug("Start  #{self.class.name}#test_simple")

			# 期待値を用意する
			from_address = MailAddress.new(SENDER_MAILADDRESS)
			to_addresses = [MailAddress.new(RECEIVER_MAILADDRESS)]
			keyword = Time.now.strftime("%Yテ%mス%dト%Hマ%Mー%Sク")
			title = "タイトルテスト@#{keyword}"
			attr1 = "属性１@#{keyword}"
			attr2 = "属性２@#{keyword}"
			message = "コンテンツテスト１行目@#{keyword}\n\nコンテンツテスト２行目@#{keyword}"

			# 編集元のブログ記事を投稿する
			(post_result, mail, postid, attachment_urls) = @weblog_testutils.post(
				WEBLOG_BLOG_ID,
				{
					'tit' => title,
					'attr1' => attr1,
					'attr2' => attr2,
				},
				message)

			# コマンドを実行する
			content = @mail_sender.make_content({"postid" => postid}, nil)
			mail = Mail.new(@mail_sender.make_title("get", WEBLOG_BLOG_ID), from_address, to_addresses, content, [])
			command = Get_CommandPlugin.new
			command.weblog = M2W_WEBLOG_EXTENSION
			command.mail_parser = @mail_parser
			command.mail_sender = @mail_sender
			command.mail = mail
			command.param = WEBLOG_BLOG_ID
			assert command.run()
			assert command.report[:original_content] != nil
			(header, content) = @mail_parser.parse_content(command.report[:original_content], {})
			assert_equal 3, header.size
			assert_equal title, header['tit']
			assert_equal attr1, header['attr1']
			assert_equal attr2, header['attr2']
			assert_equal message, content
			assert_equal postid.to_s, command.report[:postid]
			assert_equal 0, command.report[:attachments].size
			assert command.report[:link] != nil
			assert_equal 0, command.report[:errors].size
			assert_equal 0, command.report[:warnings].size

			# メールの受信を確認する
			mail = @mail_testutils.get_mail()
			assert mail != nil
			assert_equal @mail_sender.make_title("edit", WEBLOG_BLOG_ID), mail.subject
			assert_equal M2W_REPLY_ADDRESS, mail.from_address.address
			assert_equal 1, mail.to_addresses.size
			assert_equal from_address.address, mail.to_addresses[0].address
			(mail_header, mail_content) = @mail_parser.parse_content(mail.content, {})
			assert_equal 4, mail_header.size
			assert_equal postid.to_s, mail_header['postid']
			assert_equal title, mail_header['tit']
			assert_equal attr1, mail_header['attr1']
			assert_equal attr2, mail_header['attr2']
			assert_equal content, mail_content
			assert_equal 0, mail.attachments.size

			M2W_LOGGER.debug("Finish #{self.class.name}#test_simple")
		end

		if REAL_ATTACHMENTS_TEST then
			def test_attachments
				M2W_LOGGER.debug("Start  #{self.class.name}#test_attachments")

				# 期待値を用意する
				from_address = MailAddress.new(SENDER_MAILADDRESS)
				to_addresses = [MailAddress.new(RECEIVER_MAILADDRESS)]
				keyword = Time.now.strftime("%Yテ%mス%dト%Hマ%Mー%Sク")
				title = "タイトルテスト@#{keyword}"
				message = "コンテンツテスト@#{keyword}"
				attachments = REAL_ATTACHMENTS_ACTUAL

				# 取得元のブログ記事を投稿する
				(post_result, mail, postid, attachment_urls) = @weblog_testutils.post(
					WEBLOG_BLOG_ID,
					{"tit" => title},
					REAL_THUMBNAIL_MESSAGES == nil ? message : message + REAL_THUMBNAIL_MESSAGES,
					attachments)

				# コマンドを実行する
				mail_content = @mail_sender.make_content({"postid" => postid}, nil)
				mail = Mail.new(@mail_sender.make_title("get", WEBLOG_BLOG_ID), from_address, to_addresses, mail_content, [])
				command = Get_CommandPlugin.new
				command.weblog = M2W_WEBLOG_EXTENSION
				command.mail_parser = @mail_parser
				command.mail_sender = @mail_sender
				command.plugin_manager = Mail2WeblogPluginManager.new()
				command.mail = mail
				command.param = WEBLOG_BLOG_ID
				assert command.run()
				assert command.report[:original_content] != nil
				(header, content) = @mail_parser.parse_content(command.report[:original_content], {})
				assert_equal 1, header.size
				assert_equal title, header['tit']
				assert_equal REAL_THUMBNAIL_MESSAGES == nil ? message : message + REAL_THUMBNAIL_MESSAGES, content
				assert_equal postid.to_s, command.report[:postid]
				assert command.report[:attachments] != nil
				assert command.report[:link] != nil
				assert_equal 0, command.report[:errors].size
				assert_equal 0, command.report[:warnings].size

				# メールの受信を確認する
				mail = @mail_testutils.get_mail()
				assert mail != nil
				assert_equal @mail_sender.make_title("edit", WEBLOG_BLOG_ID), mail.subject
				assert_equal M2W_REPLY_ADDRESS, mail.from_address.address
				assert_equal 1, mail.to_addresses.size
				assert_equal from_address.address, mail.to_addresses[0].address
				(mail_header, mail_content) = @mail_parser.parse_content(mail.content, {})
				assert_equal 2, mail_header.size
				assert_equal postid.to_s, mail_header['postid']
				assert_equal title, mail_header['tit']
				assert_equal content, mail_content
				if REAL_ATTACHMENTS_ACTUAL != nil && REAL_ATTACHMENTS_EXPECTED != nil then
					assert_equal REAL_ATTACHMENTS_EXPECTED.clone.delete_if{|attachment| attachment == nil}.size, command.report[:attachments].clone.delete_if{|attachment| attachment == nil}.size
					i = 0
					while i < REAL_ATTACHMENTS_EXPECTED.size
						M2W_LOGGER.debug("attachment index: #{i}")

						if REAL_ATTACHMENTS_EXPECTED[i] != nil then
							assert_equal REAL_ATTACHMENTS_EXPECTED[i].content, command.report[:attachments][i].content
						else
							assert_nil command.report[:attachments][i]
						end

						i = i + 1
					end
				end

				M2W_LOGGER.debug("Finish #{self.class.name}#test_attachments")
			end
		end
	end

end
