# coding: UTF-8

require 'm2w_common'

#=簡易メール情報取得ユーティリティー
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id$
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
#
# net/pop ライブラリを使って取得したメールを解析し、情報の参照性を高めるためのユーティリティーです。
# 汎用ではなく簡易のものです。
#
# - Content-Transfer-Encoding ヘッダーの値が 7bit のもののみをサポートします。
# - 添付ファイルはサポートしません。
class Mail

  def initialize(m)
    i = 0
    buffers = m.pop.split(/\r\n|\r|\n/)

    # ヘッダーを解析する
    @header = {}
    while i < buffers.size
      buffers[i] = buffers[i].chomp

      if buffers[i] =~ /^(.+): (.+)$/ then
        @header[$1] = $2
      end

      if buffers[i] == '' then
        break
      end

      i = i + 1
    end

    # 本文を解析する
    i = i + 1
    @body = ''
    while i < buffers.size
      @body = @body + buffers[i] + "\n"

      i = i + 1
    end
  end

  def header_keys
    return @header.keys
  end

  def header(key)
    return @header[key]
  end

  # メールの本体を取得します。
  #
  # メールの本文が
  def body(to_encoding = nil)
    if @header['Content-Type'] != nil then
      if @header['Content-Type'] =~ /text\/plain; charset="(.+)"/ then
        from_encoding = $1
      end
    end

    if @header['Content-Transfer-Encoding'] != '7bit' then
      raise EncodingError.new('7bit 以外の Content-Transfer-Encoding を持つメールはサポートしていません。')
    end

    if to_encoding != nil && from_encoding != nil then
      return m2w_encode(@body, to_encoding, from_encoding)
    else
      return m2w_encode(@body, from_encoding, from_encoding)
    end
  end

end
