# coding: UTF-8

require 'm2w_common'

require 'style/hikidoc'

require 'xmlrpc/client'

#=メールを本文を解析してブログへ投稿するブログ投稿クラス =
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id$
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
#
#=想定するメールの例
#
#==タイトル例（メールヘッダーの Subject）
#
# m2w:post:1
#
# ----
#
# m2w は、mail2weblog が処理対象とするメールであることを認識するためのヘッダーです。
# m2w_config.rb で定義している M2W_SUBJECT_HEADER に従っています。
#
# post は、ブログへの投稿のコマンドであることを表しています。
# m2w_config.rb で定義している M2W_POST_COMMAND に従っています。
#
# 最後の 1 は、投稿対象となるブログのブログＩＤです。
#
#==本文例（メール本文）
#
# tit:今日の天気
# dat:20110309T07:30:00
# 
# 今日の天気は晴れです。
#
# ----
#
# メール本文にタイトルや記載日時などの情報とブログ記事の本文の両方を含めます。
# タイトル（tit）や記載日時（dat）の情報をヘッダー、空行で区切られたそれ以降の情報を本文として判断します。
#
#===ヘッダー
#
# ヘッダーは、以下のフォーマットに従ったキーと値の対を複数指定できます。
#
# キー名:値
#
# キー名には、MetaWeblog.newPost の content 構造体の名称を指定できる他 m2w_config.rb の M2W_HEADER_MAP で定義している略称も使用可能です。
# 初期設定時、tit は title を、dat は dateCreated を表しています。
#
#===ブログ記事の本文
#
# ブログ記事の本文は Hiki 構文（http://hikiwiki.org/ja/TextFormattingRules.html）に従って記載してください。
# 変換された XHTML がブログ記事として投稿されます。
# 内部で HikiDoc ライブラリを使用しています。
# HikiDoc の動作オプションは、m2w_config.rb の M2W_HIKI_OPTIONS に従います。
# 詳細は、HikiDoc ライブラリを参照してください。
class WeblogPost

  attr_accessor :host
  attr_accessor :address
  attr_accessor :username
  attr_accessor :password
  attr_accessor :blogid
  attr_accessor :attributes

  def initialize(host, address, username, password, blogid, buffer)
    @host = host
    @address = address
    @username = username
    @password = password
    @blogid = blogid
    @attributes = parse(buffer)
  end

  def parse(buffer)
    buffers = buffer.split(/\r\n|\r|\n/)

    attributes = {}

    # ヘッダーを読み込む
    i = 0
    while i < buffers.size && buffers[i] != ''
      line = buffers[i]

      if line =~ /^([a-zA-Z]+):(.+)$/ then
        key = $1
        value = $2
        if M2W_POST_COMMAND_HEADER_ALIAS.has_key?(key) then
          attributes[M2W_POST_COMMAND_HEADER_ALIAS[key]] = value
        else
          attributes[key] = value
        end
      end

      i = i + 1
    end

    # 本文を読み込む
    i = i + 1
    body = ''
    while i < buffers.size
      body = body + buffers[i] + "\n"

      i = i + 1
    end
    attributes['description'] = m2w_encode(HikiDoc.to_xhtml(body, M2W_HIKI_OPTIONS), M2W_XMLRPC_ENCODING)

    return attributes
  end

  def run(extension)
    server = XMLRPC::Client.new(@host, @address)

    if extension != nil then
      extension.postBefore(self, server)
    end

    M2W_LOGGER.info("Start  metaWeblog.newPost ... #{@attributes} to http://#{host}/#{address}, blogid = #{@blogid}")
    postid = server.call("metaWeblog.newPost", @blogid, @username, @password, @attributes)
    M2W_LOGGER.info("Finish metaWeblog.newPost ... postid = #{postid}")

    if extension != nil then
      begin
        extension.postAfter(self, server, postid)
      rescue => e
        M2W_LOGGER.error(e)
      end
    end

    return true
  end

end
