# coding: UTF-8

require 'mailutils/mail_processor'

#=ブログ投稿コマンド
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: weblog_post_command.rb 104 2011-06-27 12:18:45Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class WeblogPostCommand

	attr_reader :report

	def run(weblog, from_address, to_addresses, header, content, attachments, blogid, sender)
		@report = {}
		if weblog != nil then
			postExtension = weblog.newPostExtension
			if postExtension != nil then
				result = postExtension.post(header, content, attachments, blogid)
				@report = postExtension.report.clone

				if M2W_REPLY && sender != nil then
					mail = Mail.new("m2w:posted:#{blogid}", MailProcessor.parse_mail_address(M2W_REPLY_ADDRESS), [from_address], "postid: #{@report[:postid]}")
					sender.sendmail(mail)
				end

				return result
			end
		end

		return false
	end

end
