# coding: UTF-8

require 'mailutils/mail_processor'

#=ブログ投稿コマンド
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: weblog_post_command.rb 121 2011-07-17 12:26:08Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class WeblogPostCommand

	attr_reader :report

	def header_alias(weblog)
		if weblog != nil then
			postExtension = weblog.newPostExtension
			if postExtension != nil then
				return postExtension.header_alias
			end
		end

		return nil
	end

	def run(weblog, from_address, to_addresses, header, content, attachments, blogid, sender)
		@report = {}
		if weblog != nil then
			postExtension = weblog.newPostExtension
			if postExtension != nil then
				result = postExtension.post(header, content, attachments, blogid)
				@report = postExtension.report.clone

				if M2W_REPLY && sender != nil then
					sender.sendmail_as_command("posted", blogid, {"postid" => @report[:postid]}, nil, from_address, [])
				end

				return result
			end
		end

		return false
	end

end
