# coding: UTF-8

require 'plugin/weblog/metaweblog/metaweblog_extension'
require 'plugin/weblog/metaweblog/xmlrpc_parser'
require 'plugin/weblog/wordpress/wordpress_post_extension'

M2W_WEBLOG_WORDPRESS_DEFAULT_ENCODING = 'UTF-8'
M2W_WEBLOG_WORDPRESS_ATTACHMENT_ROOT_PATH = 'attrs'
M2W_WEBLOG_WORDPRESS_XMLRPC_ENCODING = 'UTF-8'

#=WordPress のための拡張モジュールです。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: wordpress_extension.rb 119 2011-07-16 00:52:57Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class WordPressExtension < MetaWeblogExtension

	def initialize(host = M2W_WEBLOG_HOST, address = M2W_WEBLOG_ADDRESS, username = M2W_WEBLOG_USERNAME, password = M2W_WEBLOG_PASSWORD, encoding = M2W_WEBLOG_WORDPRESS_DEFAULT_ENCODING, attachment_root_path = M2W_WEBLOG_WORDPRESS_ATTACHMENT_ROOT_PATH)
		super
	end

	def server
		result = XMLRPC::Client.new(host, address)
		result.set_parser(XMLRPCParser.new(M2W_WEBLOG_WORDPRESS_XMLRPC_ENCODING))
		return result
	end

	# ブログへ投稿する際の拡張モジュールを取得する
	def newPostExtension()
		return WordPressPostExtension.new(self)
	end

end
