# coding: UTF-8

#=blogger API
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: blogger.rb 152 2011-08-05 23:31:27Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Blogger

	def initialize(server, username, password, encoding)
		@server = server
		@username = username
		@password = password
		@encoding = encoding
	end

	def get_users_blogs(appkey = "")
		M2W_LOGGER.debug("Start  blogger.get_users_blogs ... appkey = #{appkey}, username = #{@username}")
		blogs = @server.call("blogger.getUsersBlogs", appkey, @username, @password)
		M2W_LOGGER.debug("Finish blogger.get_users_blogs ... blogs = #{blogs.to_s}")
		result = {}
		blogs.each do |blog|
			result[blog["blogid"]] = Blog.new(blog["blogid"].encode(@encoding), blog["url"].encode(@encoding), blog["blogName"].encode(@encoding))
		end
		return result
	end

end

class Blog

	attr_reader :blogid
	attr_reader :url
	attr_reader :blog_name

	def initialize(blogid, url, blog_name)
		@blogid = blogid
		@url = url
		@blog_name = blog_name
	end

end
