# coding: UTF-8

require 'plugin/weblog/meta_weblog/meta_weblog'
require 'plugin/weblog/movable_type/movable_type_post'

M2W_WEBLOG_MT_DEFAULT_ENCODING = 'UTF-8'
M2W_WEBLOG_MT_ATTACHMENT_ROOT_PATH = 'attachments/'

#=Movable Type のためのウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: movable_type.rb 175 2011-08-09 15:05:28Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class MovableType_WeblogPlugin < MetaWeblog_WeblogPlugin

	attr_reader :host
	attr_reader :address
	attr_reader :username
	attr_reader :password
	attr_reader :encoding
	attr_reader :attachment_root_path

	def initialize(host = M2W_WEBLOG_HOST, address = M2W_WEBLOG_ADDRESS, username = M2W_WEBLOG_USERNAME, password = M2W_WEBLOG_PASSWORD, encoding = M2W_WEBLOG_MT_DEFAULT_ENCODING, attachment_root_path = M2W_WEBLOG_MT_ATTACHMENT_ROOT_PATH)
		super
	end

	# 添付ファイルのパスを取得します。
	def get_attachment_filepath(postid, attachment_index, attachment_filename)
		return "#{@attachment_root_path}#{postid}/#{attachment_index}#{File.extname(attachment_filename)}"
	end

	# ブログ記事投稿用のプラグインを取得します。
	def get_post_plugin()
		return MovableTypePost_WeblogPlugin.new(self)
	end

end
