# coding: UTF-8
# 

ROOT_PATH = File.dirname(File.expand_path(__FILE__))

$:.unshift(ROOT_PATH + "/../")
$:.unshift(ROOT_PATH + "/../../main/")
$:.unshift(ROOT_PATH + "/../../main/lib")

# mail2weblog のルートパスを設定する
M2W_ROOT_PATH = ROOT_PATH + "/../../main/"

require 'm2w_configurator'
require 'm2w_plugin_manager'
require 'style/formatter'
require 'mailutils/mail_processor'

require 'minitest/unit'

MiniTest::Unit.autorun

class Example_FormatPlugin

	def plugin_contents(param, vars)
		case param
		when "warning"
			raise FormatPluginWarning.new("warning", "warning")
		when "error"
			raise FormatPluginError.new("error", "error")
		else
			return "example"
		end
	end

	def plugin_contents_inline(param, vars)
		case param
		when "warning"
			raise FormatPluginWarning.new("warning_inline", "warning_inline")
		when "error"
			raise FormatPluginError.new("error_inline", "error_inline")
		else
			return "example_inline"
		end
	end

end

#=Mail2WeblogMailParser のテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_formatter.rb 213 2011-08-17 15:15:37Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestFormatter < MiniTest::Unit::TestCase

	def setup
		@formatter = Formatter.new(Mail2WeblogPluginManager.new)
	end

	def test_preformat
content = <<"END_CONTENT"
１行目

２行目
END_CONTENT

content_with_header = <<"END_CONTENT"
tit.タイトル <&>

１行目

２行目
END_CONTENT

expected_content = <<"END_CONTENT"
<!--m2w_version:#{M2W_VERSION}--><!--[wikicontent] tit.タイトル &lt;&amp;&gt;

１行目

２行目
 --><p>１行目</p>
<p>２行目</p>
END_CONTENT

		assert_equal expected_content.chomp, @formatter.preformat(content, content_with_header, false)
	end

	def test_format_with_plugin_inline
expected_precontent = <<"END_CONTENT"
<div class="plugin">{{example}}</div>
END_CONTENT

		assert_equal expected_precontent.chomp, @formatter.preformat('{{example}}', '{{example}}', false)

expected_postcontent = <<"END_CONTENT"
<!--m2w_version:#{M2W_VERSION}--><!--[wikicontent] {{example}} -->example
END_CONTENT

		assert_equal expected_postcontent.chomp, @formatter.postformat(expected_precontent, {})
	end

	def test_format_with_plugin_warning
		precontent = @formatter.preformat('{{example(warning)}}', '{{example(warning)}}', false)
		assert_match %r!\{\{警告: warning\}\}$!, @formatter.postformat(precontent, {})
	end

	def test_format_with_plugin_error_inline
		precontent = @formatter.preformat('{{example(error)}}', '{{example(error)}}', false)
		assert_match %r!\{\{エラー: error\}\}$!, @formatter.postformat(precontent, {})
	end

	def test_format_with_plugin
expected_precontent = <<"END_CONTENT"
<p>テスト<span class="plugin">{{example}}</span></p>
END_CONTENT

		assert_equal expected_precontent.chomp, @formatter.preformat('テスト{{example}}', 'テスト{{example}}', false)

expected_postcontent = <<"END_CONTENT"
<!--m2w_version:#{M2W_VERSION}--><!--[wikicontent] テスト{{example}} --><p>テストexample_inline</p>
END_CONTENT

		assert_equal expected_postcontent.chomp, @formatter.postformat(expected_precontent, {})
	end

	def test_format_with_plugin_warning_inline
		precontent = @formatter.preformat('テスト{{example(warning)}}', 'テスト{{example(warning)}}', false)
		assert_match %r!<p>テスト{{警告: warning_inline}}</p>$!, @formatter.postformat(precontent, {})
	end

	def test_format_with_plugin_error_inline
		precontent = @formatter.preformat('テスト{{example(error)}}', 'テスト{{example(error)}}', false)
		assert_match %r!<p>テスト{{エラー: error_inline}}</p>$!, @formatter.postformat(precontent, {})
	end

	def test_format_with_attachment
expected_precontent = <<"END_CONTENT"
<p>テスト</p>
END_CONTENT

		assert_equal expected_precontent.chomp, @formatter.preformat('テスト', 'テスト', true)

expected_postcontent = <<"END_CONTENT"
<!--m2w_version:#{M2W_VERSION}--><!--[wikicontent] テスト --><!--[attachment_urls] 1=http://abc.def.ghi/jkl.txt --><p>テスト</p>
END_CONTENT

		vars = {
			:attachment_urls => {1 => 'http://abc.def.ghi/jkl.txt'}
		}
		assert_equal expected_postcontent.chomp, @formatter.postformat(expected_precontent, vars)
	end

	def test_format_with_attachments
expected_precontent = <<"END_CONTENT"
<p>テスト</p>
END_CONTENT

		assert_equal expected_precontent.chomp, @formatter.preformat('テスト', 'テスト', true)

expected_postcontent = <<"END_CONTENT"
<!--m2w_version:#{M2W_VERSION}--><!--[wikicontent] テスト --><!--[attachment_urls] 1=http://abc.def.ghi/jkl.txt,2=http://mno.pqr.stu/vwx.txt --><p>テスト</p>
END_CONTENT

		vars = {
			:attachment_urls => {
				1 => 'http://abc.def.ghi/jkl.txt',
				2 => 'http://mno.pqr.stu/vwx.txt',
			}
		}
		assert_equal expected_postcontent.chomp, @formatter.postformat(expected_precontent, vars)
	end

	def test_get_uncommentout_content
content = <<"END_CONTENT"
<!--m2w_version:#{M2W_VERSION}--><!--[wikicontent] tit.タイトル &lt;&amp;&gt;

１行目

２行目 --><p>１行目</p>
<p>２行目</p>
END_CONTENT

expected_content = <<"END_CONTENT"
tit.タイトル <&>

１行目

２行目
END_CONTENT

		(version, content) = @formatter.get_uncommentout_content(content)
		assert_equal M2W_VERSION, version
		assert_equal expected_content.chomp, content
	end

	def test_get_uncommentout_content_old
content = <<"END_CONTENT"
<!-- １行目

２行目 --><p>１行目</p>
<p>２行目</p>
END_CONTENT

expected_content = <<"END_CONTENT"
１行目

２行目
END_CONTENT

		(version, content) = @formatter.get_uncommentout_content(content)
		assert version == nil
		assert_equal expected_content.chomp, content
	end

end
