# coding: UTF-8

ROOT_PATH = File.dirname(File.expand_path(__FILE__)) + "/../../m2w"

$:.unshift(ROOT_PATH + "/")
$:.unshift(ROOT_PATH + "/../")
$:.unshift(ROOT_PATH + "/../../main/")
$:.unshift(ROOT_PATH + "/../../main/lib")

# mail2weblog のルートパスを設定する
M2W_ROOT_PATH = ROOT_PATH + "/../../main/"

require 'm2w_configurator'
require 'm2w_mail_parser'
require 'm2w_mail_sender'
require 'conf/setting'
require 'mailutils/mail_processor'
require 'testutils/accessor'
require 'testutils/mail_testutils'
require 'testutils/weblog_testutils'

require 'minitest/unit'

MiniTest::Unit.autorun

#=添付画像を貼り付ける img 書式プラグインのテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_img_plugin.rb 295 2011-09-24 01:52:50Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestImgFormatPlugin < MiniTest::Unit::TestCase

	def test_contents
		plugin = Img_FormatPlugin.new

		vars = {
			:attachment_urls => {1 => "http://abc.def.ghi/jkl.jpg"},
		}
		result = plugin.plugin_contents('', vars)
		assert_equal %Q!<div><img src="http://abc.def.ghi/jkl.jpg" /></div>!, result

		result = plugin.plugin_contents('1', vars)
		assert_equal %Q!<div><img src="http://abc.def.ghi/jkl.jpg" /></div>!, result

		assert_raises(FormatPluginWarning) do
			result = plugin.plugin_contents('0', vars)
		end

		assert_raises(FormatPluginWarning) do
			result = plugin.plugin_contents('2', vars)
		end
	end

	def test_contents_template
		plugin = Img_FormatPlugin.new

		vars = {
			:attachment_urls => {1 => "http://abc.def.ghi/jkl.jpg"},
			:thumbnail_urls => {1 => "http://abc.def.ghi/jkl_thumb.jpg"},
		}
		result = plugin.plugin_contents('/template_name@hs.b/alt@テスト', vars)
		assert_equal %Q!<div><a href="http://abc.def.ghi/jkl.jpg" class="highslide" onclick="return hs.expand(this)"><img src="http://abc.def.ghi/jkl_thumb.jpg" alt="テスト" /></a></div>!, result

		result = plugin.plugin_contents('1/template_name@hs.b/alt@テスト', vars)
		assert_equal %Q!<div><a href="http://abc.def.ghi/jkl.jpg" class="highslide" onclick="return hs.expand(this)"><img src="http://abc.def.ghi/jkl_thumb.jpg" alt="テスト" /></a></div>!, result

		assert_raises(FormatPluginWarning) do
			result = plugin.plugin_contents('0/template_name@hs.b/alt@テスト', vars)
		end

		assert_raises(FormatPluginWarning) do
			result = plugin.plugin_contents('2/template_name@hs.b/alt@テスト', vars)
		end
	end

	def test_contents_custom_template
		plugin = Img_FormatPlugin.new

		vars = {
			:attachment_urls => {1 => "http://abc.def.ghi/jkl.jpg"},
			:thumbnail_urls => {1 => "http://abc.def.ghi/jkl_thumb.jpg"},
		}
		result = plugin.plugin_contents('1/template_name@custom/alt@テスト/template_custom@abcdef', vars)
		assert_equal %Q!<div>abcdef</div>!, result
	end

	def test_plugin_contents_inline
		plugin = Img_FormatPlugin.new

		vars = {
			:attachment_urls => {1 => "http://abc.def.ghi/jkl.jpg"},
		}
		result = plugin.plugin_contents_inline('', vars)
		assert_equal %Q!<img src="http://abc.def.ghi/jkl.jpg" />!, result

		result = plugin.plugin_contents_inline('1', vars)
		assert_equal %Q!<img src="http://abc.def.ghi/jkl.jpg" />!, result

		assert_raises(FormatPluginWarning) do
			result = plugin.plugin_contents_inline('0', vars)
		end

		assert_raises(FormatPluginWarning) do
			result = plugin.plugin_contents_inline('2', vars)
		end
	end

	def test_contents_inline_template
		plugin = Img_FormatPlugin.new

		vars = {
			:attachment_urls => {1 => "http://abc.def.ghi/jkl.jpg"},
			:thumbnail_urls => {1 => "http://abc.def.ghi/jkl_thumb.jpg"},
		}
		result = plugin.plugin_contents_inline('/template_name@hs.b/alt@テスト', vars)
		assert_equal %Q!<a href="http://abc.def.ghi/jkl.jpg" class="highslide" onclick="return hs.expand(this)"><img src="http://abc.def.ghi/jkl_thumb.jpg" alt="テスト" /></a>!, result

		result = plugin.plugin_contents_inline('1/template_name@hs.b/alt@テスト', vars)
		assert_equal %Q!<a href="http://abc.def.ghi/jkl.jpg" class="highslide" onclick="return hs.expand(this)"><img src="http://abc.def.ghi/jkl_thumb.jpg" alt="テスト" /></a>!, result

		assert_raises(FormatPluginWarning) do
			result = plugin.plugin_contents_inline('0/template_name@hs.b/alt@テスト', vars)
		end

		assert_raises(FormatPluginWarning) do
			result = plugin.plugin_contents_inline('2/template_name@hs.b/alt@テスト', vars)
		end
	end

	def test_contents_inline_custom_template
		plugin = Img_FormatPlugin.new

		vars = {
			:attachment_urls => {1 => "http://abc.def.ghi/jkl.jpg"},
			:thumbnail_urls => {1 => "http://abc.def.ghi/jkl_thumb.jpg"},
		}
		result = plugin.plugin_contents_inline('1/template_name@custom/alt@テスト/template_custom@abcdef', vars)
		assert_equal %Q!abcdef!, result
	end

end
