# coding: UTF-8

require 'mailutils/mail_processor'

#=[ɊւeXg[eBeB
#
# ŏ̒:: gDC[
# |Wg:: $Id: weblog_testutils.rb 410 2011-12-05 02:10:29Z toy_dev $
# 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
# CZX:: CPL(Common Public Licence)
class WeblogTestUtils

	def initialize(mail_parser, mail_sender, plugin_manager, mail_testutils, sender_mailaddress)
		@mail_parser = mail_parser
		@mail_sender = mail_sender
		@plugin_manager = plugin_manager
		@mail_testutils = mail_testutils
		@sender_mailaddress = sender_mailaddress
	end

	def post(blogid, header, content, attachments = [])
		from_address = MailAddress.new(@sender_mailaddress)
		to_addresses = [MailAddress.new(M2W_POP3_SERVER_ADDRESS)]
		mail = Mail.new("m.post.#{blogid}", from_address, to_addresses, @mail_sender.make_content(header, content), attachments)

		command = Post_CommandPlugin.new
		command.weblog = M2W_WEBLOG_EXTENSION
		command.mail_parser = @mail_parser
		command.mail_sender = @mail_sender
		command.plugin_manager = @plugin_manager
		command.mail = mail
		command.param = blogid
		command_result = command.run()
		mail = @mail_testutils.get_mail
		if command_result then
			return [command_result, mail, command.report[:postid], command.report[:attachment_urls]]
		else
			return [command_result, mail]
		end
	end

	def get(blogid, postid, header_alias = {})
		from_address = MailAddress.new(@sender_mailaddress)
		to_addresses = [MailAddress.new(M2W_POP3_SERVER_ADDRESS)]
		header = {"postid" => postid}
		mail = Mail.new("m.post.#{blogid}", from_address, to_addresses, @mail_sender.make_content(header, nil))
		command = Get_CommandPlugin.new
		command.weblog = M2W_WEBLOG_EXTENSION
		command.mail_parser = @mail_parser
		command.mail_sender = @mail_sender
		command.mail = mail
		command.param = blogid
		command_result = command.run()
		mail = @mail_testutils.get_mail
		if command_result then
			(header, content) = @mail_parser.parse_content(command.report[:original_content], header_alias)
			header.delete(M2W_FORMAT_PLUGIN_CONF_HEADER_NAME)
			return [command_result, mail, header, content, command.report[:attachments], command.report[:link]]
		else
			return [command_result, mail]
		end
	end

end
