# coding: UTF-8

require 'plugin/weblog/lib/standard_command'
require 'plugin/weblog/lib/weblog_plugin_error'
require 'plugin/weblog/meta_weblog/lib/meta_weblog_post_common'

#=metaWeblog API を使った標準のブログ記事投稿用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: metaweblog_post_extension.rb 132 2011-08-06 00:33:02Z yutaka_at_home $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class MetaWeblogPost_WeblogPlugin < StandardCommand_WeblogPlugin
	include MetaWeblogPostCommon

	def header_alias
		return M2W_META_WEBLOG_POST_HEADER_ALIAS
	end

	def post(original_content, header, content, contents, attachments, blogid)
		M2W_LOGGER.debug("Start  #{self.class.name}#post ... endpoint = #{@parent.endpoint}, blogid = #{blogid}, header = #{header}")

		if blogid == '' && @parent.default_blogid != nil && @parent.default_blogid != '' then
			blogid = @parent.default_blogid
		end

		if blogid == '' then
			M2W_LOGGER.error("ブログＩＤが指定されていません。")
			@errors.push(WeblogPluginError.new(
				"ブログＩＤ未指定",
				"ブログＩＤが未指定でした。"))
			return false
		end

		client = @parent.client
		formatter = @parent.formatter
		postid = nil

		begin
			before(client, header, content, attachments, blogid)

			# ブログ記事を仮投稿する
			begin
				M2W_LOGGER.debug("Start  metaWeblog.newPost ... blogid = #{blogid}")
				postid = client.call(
					"metaWeblog.newPost",
					blogid,
					@parent.username,
					@parent.password,
					{'title' => M2W_TEMP_POST_TITLE, 'description' => M2W_TEMP_POST_DESCRIPTION},
					0)
				postid = parse_postid(postid).to_s
				M2W_LOGGER.debug("Finish metaWeblog.newPost ... postid = #{postid}")
			rescue Exception => e
				M2W_LOGGER.error("ブログ記事の仮投稿に失敗しました。")
				M2W_LOGGER.error(e)
				@errors.push(WeblogPluginError.new(
					"ブログ記事仮投稿エラー(メッセージ = #{e.message})",
					"ブログ記事の仮投稿に失敗しました(メッセージ = #{e.message})。"))
				M2W_LOGGER.debug("Finish #{self.class.name}#post ... result = false")
				return false
			end

			vars = {:blogid => blogid, :postid => postid, :encoding => @parent.encoding, M2W_FORMAT_PLUGIN_CONF_HEADER_NAME => header[M2W_FORMAT_PLUGIN_CONF_HEADER_NAME]}
			vars.merge!(header)

			# 書式プラグインの事前処理を行う
			formatter.preset(
				original_content, content, contents, vars, @errors, @warnings)

			# 投稿日付を取得する
			dateCreated = @parent.parse_date(header['dateCreated'], Time.now, @errors, @warnings)
			if header['dateCreated'] != nil then
				header['dateCreated'] = @parent.get_date(dateCreated)
			end

			# 添付ファイルを投稿する
			(attachment_urls, thumbnail_urls) = post_attachments(client, @parent.username, @parent.password, blogid, postid, header, vars, attachments, dateCreated, @errors, @warnings)
			vars[:attachment_urls] = attachment_urls
			vars[:thumbnail_urls] = thumbnail_urls

			# 書式変換を行う
			formatted_contents = nil
			begin
				formatted_contents = formatter.format(
					original_content, content, contents, vars, @errors, @warnings)
				header.merge!(formatted_contents)
			rescue Exception => e
				M2W_LOGGER.error("ブログ記事の書式変換に失敗しました。")
				M2W_LOGGER.error(e)
				@errors.push(WeblogPluginError.new(
					"書式変換エラー(メッセージ = #{e.message})",
					"ブログ記事の書式変換に失敗しました(メッセージ = #{e.message})。"))
				raise e
			end

			# 書式変換した結果を再投稿する
			begin
				M2W_LOGGER.debug("Start  metaWeblog.editPost ...")
				result = client.call("metaWeblog.editPost", postid, @parent.username, @parent.password, get_header_for_post(header), 1)
				M2W_LOGGER.debug("Finish metaWeblog.editPost ... result = #{result}")
			rescue Exception => e
				M2W_LOGGER.error("ブログ記事の書式変換後の投稿に失敗しました。")
				M2W_LOGGER.error(e)
				@errors.push(WeblogPluginError.new(
					"書式変換後ブログ記事投稿エラー(メッセージ = #{e.message})",
					"ブログ記事の書式プラグイン適用に失敗しました。(メッセージ = #{e.message})。"))
				raise e
			end

			after(client, header, content, attachments, blogid, postid)

			@report[:original_content] = original_content
			@report[:postid] = postid
			@report[:attachment_urls] = attachment_urls
			@report[:thumbnail_urls] = thumbnail_urls
			@report[:title] = header['title']

			M2W_LOGGER.debug("Finish #{self.class.name}#post")
		rescue Exception => e
			M2W_LOGGER.error("ブログ記事の投稿に失敗しました。")
			M2W_LOGGER.error(e)
			@errors.push(WeblogPluginError.new(
				"ブログ記事投稿エラー(投稿ＩＤ = #{postid}, メッセージ = #{e.message})",
				"ブログ記事の投稿に失敗しました。仮投稿したブログ記事の削除を試みます(投稿ＩＤ = #{postid}, メッセージ = #{e.message})。"))
			begin
				M2W_LOGGER.debug("Start  blogger.deletePost ... blogid = #{blogid}, postid = #{postid}")
				result = client.call(
					"blogger.deletePost",
					1,
					postid,
					@parent.username,
					@parent.password,
					1)
				M2W_LOGGER.debug("Finish blogger.deletePost ... result = #{result}")
				@errors.push(WeblogPluginError.new(
					"仮投稿ブログ記事削除済み(投稿ＩＤ = #{postid})",
					"仮投稿ブログ記事の削除に成功しました。ブログ記事を再投稿するには投稿内容を再確認してください(投稿ＩＤ = #{postid})。"))
			rescue Exception => e
				M2W_LOGGER.error("ブログ記事の削除に失敗しました。")
				M2W_LOGGER.error(e)
				@errors.push(WeblogPluginError.new(
					"仮投稿ブログ記事削除エラー(投稿ＩＤ = #{postid}, メッセージ = #{e.message})",
					"仮投稿ブログ記事の削除に失敗しました。該当のブログ記事を手動で削除してください(投稿ＩＤ = #{postid}, メッセージ = #{e.message})。"))
			end

			M2W_LOGGER.debug("Finish #{self.class.name}#post ... result = false")
			return false
		end

		M2W_LOGGER.debug("Finish #{self.class.name}#post ... result = true")
		return true
	end

	def parse_postid(postid)
		return postid
	end

	def before(client, header, content, attachments, blogid)
	end

	def after(client, header, content, attachments, blogid, postid)
	end

end
