# coding: UTF-8

require 'net/http'
require 'lib/exception/m2w_error'
require 'lib/exception/m2w_warning'

module WeblogPostCommon

	def post_medias(client, username, password, blogid, postid, header, vars, attachments, dateCreated, errors, warnings)
		M2W_LOGGER.debug("Start  #{self.class}#post_medias ... header = #{header.to_s}, vars = #{vars.to_s}")

		mime = Mime.new

		thumbnail_setting = __get_thumbnail_setting(header, vars)
		M2W_LOGGER.debug("__get_thumbnail_setting ... thumbnail_setting = #{thumbnail_setting.to_s}")		

		# 添付ファイルを投稿する
		attachment_urls = {}
		thumbnail_urls = {}
		if attachments != nil && attachments.size > 0 then
			attachments.each_with_index do |attachment, i|
				attachment_index = i + 1

				# 通常画像を投稿する
				attachment_urls[attachment_index] = nil
				begin
					media_name = @parent.get_attachment_filepath(postid, dateCreated, attachment_index, attachment.filename)
					media_url = post_media(attachment.content, attachment_index, media_name, client, username, password, blogid, postid, header, vars, attachments, dateCreated, errors, warnings)
					if media_url != nil then
						attachment_urls[attachment_index] = media_url
					else
						errors.push(WeblogPluginError.new(
							"添付ファイル転送エラー(添付インデックス = #{attachment_index}, 添付ファイル名 = #{attachment.filename})",
							"添付ファイル転送に失敗しました(添付インデックス = #{attachment_index}, 添付ファイル名 = #{attachment.filename})。"))
					end
				rescue => e
					M2W_LOGGER.error("添付ファイルの転送に失敗しました。")
					M2W_LOGGER.error(e)
					errors.push(WeblogPluginError.new(
						"添付ファイル転送エラー(添付インデックス = #{attachment_index}, 添付ファイル名 = #{attachment.filename})",
						"添付ファイルの転送に失敗しました(添付インデックス = #{attachment_index}, 添付ファイル名 = #{attachment.filename})。"))
				end

				# サムネイル画像を投稿する
				if M2W_SYSTEM_RMAGICK_SUPPORTED then
					begin
						thumbnail = __create_thumbnail(attachment.content, thumbnail_setting, attachment_index.to_s)
					rescue => e
						M2W_LOGGER.error("サムネイルの作成に失敗しました。")
						M2W_LOGGER.error(e)
						errors.push(WeblogPluginError.new(
							"サムネイル作成エラー(添付インデックス = #{attachment_index}, 添付ファイル名 = #{attachment.filename})",
							"サムネイルの作成に失敗しました(添付インデックス = #{attachment_index}, 添付ファイル名 = #{attachment.filename})。"))
					end

					if thumbnail != nil then
						M2W_LOGGER.debug("create thumbnail ... index = #{attachment_index}, filename = #{attachment.filename}")

						begin
							media_name = @parent.get_thumbnail_filepath(postid, dateCreated, attachment_index, attachment.filename)
							media_url = post_media(thumbnail.to_blob, attachment_index, media_name, client, username, password, blogid, postid, header, vars, attachments, dateCreated, errors, warnings)
							if media_url != nil then
								thumbnail_urls[attachment_index] = media_url
							else
								thumbnail_urls[attachment_index] = nil
								errors.push(WeblogPluginError.new(
									"サムネイル転送エラー(添付インデックス = #{attachment_index}, 添付ファイル名 = #{attachment.filename})",
									"サムネイル転送に失敗しました(添付インデックス = #{attachment_index}, 添付ファイル名 = #{attachment.filename})。"))
							end
						rescue => e
							thumbnail_urls[attachment_index] = nil
							M2W_LOGGER.error("添付ファイルの転送に失敗しました。")
							M2W_LOGGER.error(e)
							errors.push(WeblogPluginError.new(
								"サムネイル転送エラー(添付インデックス = #{attachment_index}, 添付ファイル名 = #{attachment.filename})",
								"サムネイルの転送に失敗しました(添付インデックス = #{attachment_index}, 添付ファイル名 = #{attachment.filename})。"))
						end
					end
				end
			end
		end

		M2W_LOGGER.debug("Finish #{self.class}#post_medias ... attachment_urls = #{attachment_urls.to_s}, thumbnail_urls = #{thumbnail_urls.to_s}")
		return [attachment_urls, thumbnail_urls]
	end

	def post_media(content, attachment_index, media_name, client, username, password, blogid, postid, header, vars, attachments, dateCreated, errors, warnings)
		raise WeblogPluginError.new(
			"未実装エラー",
			"実装されていません。")
	end

	def get_header_for_post(header)
		result = header.clone
		result.delete_if do |key, value|
			key == M2W_FORMAT_PLUGIN_CONF_HEADER_NAME || key =~ /^fmt_[0-9a-zA-Z]+$/
		end

		return result
	end

	def request_trackback(client, header, blogid)
		M2W_LOGGER.debug("Start  #{self.class}#request_trackback ... header = #{header.to_s}, blogid = #{blogid}")

		if header['tb'] != nil then
			begin
				tb_urls = header['tb'].split(/[\s,]/)

				url = get_url4trackback(client, blogid, @report[:postid])
				blog_name = get_blog_name4trackback(client, blogid)

				title = header['title'] != nil ? header['title'] : ""
				excerpt = header['excerpt']
				if excerpt == nil then
					excerpt = ''
					# Ruby 1.9.0 より下のバージョンではマルチバイト文字列を綺麗に切れないため本文の要約に対応しない
					if RUBY_VERSION >= '1.9.0' then
						(header, content, contents) = @parent.mail_parser.parse_content(@report[:original_content])
						excerpt = contents['description'].length > 23 ? "#{contents['description'].slice(0, 23)} ..." : contents['description']
					end
				end

				tb_urls.each do |tb_url|
					M2W_LOGGER.debug("trackback to #{tb_url} ... title = #{title}, excerpt = #{excerpt}, url = #{url}, blog_name = #{blog_name}")
					response = Net::HTTP.post_form(
						URI.parse(tb_url),
						{
							'charset' => M2W_SYSTEM_INNER_ENCODING,
							'title' => title,
							'excerpt' => excerpt,
							'url' => url,
							'blog_name' => blog_name
						}
					)
					case response
					when Net::HTTPSuccess
						M2W_LOGGER.debug("trackback response = #{response.body}")
						if %r!<error>\s*([0-9]+)?\s*</error>! =~ response.body then
							error = $1
							if error != '0' then
								message = ''
								if %r!<message>(.+?)</message>! =~ response.body then
									message = $1
								end
								warnings.push(WeblogPluginWarnings.new(
									"トラックバック送信エラー(送信先 = #{tb_url}, メッセージ = #{message})",
									"トラックバックの送信に失敗しました(送信先 = #{tb_url}, メッセージ = #{message})。"))
							end
						end
					else
						warnings.push(WeblogPluginWarnings.new(
							"トラックバック送信エラー(送信先 = #{tb_url})",
							"トラックバックの送信に失敗しました(送信先 = #{tb_url}"))
					end
				end
			rescue => e
				M2W_LOGGER.error("トラックバックの転送に失敗しました。")
				M2W_LOGGER.error(e)
				warnings.push(WeblogPluginWarnings.new(
					"トラックバック転送エラー(メッセージ = #{e.message})",
					"トラックバックの転送に失敗しました(メッセージ = #{e.message})。"))
			end

			M2W_LOGGER.debug("Finish #{self.class}#request_trackback")
		end
	end

	def get_url4trackback(client, blogid, postid)
		get_plugin = @parent.get_get_plugin()
		result = get_plugin.get({'postid' => postid}, '', [], blogid)
		if get_plugin.report[:link] != nil then
			return get_plugin.report[:link]
		else
			raise WeblogPluginWarning.new(
				"リンク取得エラー",
				"リンクの取得に失敗しました。"
			)
		end
	end

	def get_blog_name4trackback(client, blogid)
	end

	def __get_thumbnail_setting(header, vars)
		M2W_LOGGER.debug("Start  #{self.class}#__get_thumbnail_setting ... header = #{header.to_s}, vars = #{vars.to_s}")

		result = {}
		if header.has_key?('thumbnail_scale') then
			result[0] = {'scale' => header['thumbnail_scale'].to_i}
		elsif header.has_key?('thumbinal_width') && header.has_key?('thumbinal_height') then
			result[0] = {'width' => header['thumbnail_width'].to_i, 'height' => header['thumbnail_height'].to_i}
		end

		if vars[M2W_FORMAT_PLUGIN_CONF_HEADER_NAME] != nil && vars[M2W_FORMAT_PLUGIN_CONF_HEADER_NAME].has_key?(M2W_WEBLOG_PLUGIN_CONF_THUMBNAIL_VAR_NAME) then
			M2W_LOGGER.debug("has thumbnail setting ... #{vars[M2W_FORMAT_PLUGIN_CONF_HEADER_NAME][M2W_WEBLOG_PLUGIN_CONF_THUMBNAIL_VAR_NAME].to_s}")
			vars[M2W_FORMAT_PLUGIN_CONF_HEADER_NAME][M2W_WEBLOG_PLUGIN_CONF_THUMBNAIL_VAR_NAME].each do |index, thumbnail_presetting|
				result[index.to_s] = thumbnail_presetting
			end
		end

		M2W_LOGGER.debug("Finish #{self.class}#__get_thumbnail_setting ... result = #{result.to_s}")
		return result
	end

	def __create_thumbnail(attachment_content, thumbnail_setting, attachment_index)
		M2W_LOGGER.debug("Start  #{self.class}#__create_thumbnail ... thumbnail_setting = #{thumbnail_setting.to_s}, attachment_index = #{attachment_index}")

		setting = thumbnail_setting[0]
		if thumbnail_setting[attachment_index] != nil then
			setting = thumbnail_setting[attachment_index]
		end

		begin
			if setting != nil then
				if setting['scale'] != nil then
					M2W_LOGGER.debug("create thumbnail ... scale = #{setting['scale']}")
					return Magick::Image.from_blob(attachment_content).shift.scale(0.01 * setting['scale'].to_i)
				elsif setting['width'] != nil && setting['height'] != nil then
					M2W_LOGGER.debug("create thumbnail ... width = #{setting['width']}, height = #{setting['height']}")
					return Magick::Image.from_blob(attachment_content).shift.scale(setting['width'].to_i, setting['height'].to_i)
				end
			end

			M2W_LOGGER.debug("no create thumbnail ... setting = #{setting.to_s}")
			return nil
		ensure
			M2W_LOGGER.debug("Finish #{self.class}#__create_thumbnail")
		end
	end

	def __modify_media_url(media_url, media_name)
		if %r!^(.+?)(/?)#{media_name}$! =~ media_url then
			return "#{$1}/#{media_name}"
		else
			return media_url
		end
	end

end
