# coding: UTF-8

require 'm2w_mail_parser_plain_text_type'
require 'm2w_mail_parser_html_text_type'

#=メール解析
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: m2w_mail_parser.rb 677 2012-05-13 00:43:49Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Mail2WeblogMailParser

	def initialize(subject_header, subject_separator, header_alias = {})
		@subject_header = subject_header
		@subject_separator = subject_separator
		if header_alias != nil then
			@header_alias = header_alias.clone
		else
			@header_alias = {}
		end
	end

	def parse_subject(subject)
		if @subject_header != nil then
			if subject =~ /^#{@subject_header}#{@subject_separator}(.+?)#{@subject_separator}(.+?)$/ then
				command_name = $1
				param = $2
				return [command_name, param]
			elsif subject =~ /^#{@subject_header}#{@subject_separator}(.+?)$/ then
				command_name = $1
				return [command_name, '']
			end
		else
			if subject =~ /^(.+?)#{@subject_separator}(.+?)$/ then
				command_name = $1
				param = $2
				return [command_name, param]
			else
				return [subject, '']
			end
		end

		return nil
	end

	def escaped_prefix_content(content, first_line)
		lines = content.split(/\r\n|\r|\n/)

		# first_line が見つかるまでヘッダーを除去する
		result = ""
		index = 0
		while index < lines.size
			if /^(> *)?#{first_line}/ =~ lines[index] then
				break
			end

			index = index + 1
		end

		# > 
		while index < lines.size
			if /^(> *)?(.+)$/ =~ lines[index] then
				result << $2
			end

			if index != lines.size - 1 then
				result << "\n"
			end

			index = index + 1
		end

		return result
	end

	def parse_content(content, header_alias_plus = {}, type = Mail2WeblogMailParserPlainTextType.new)
		buffers = type.split(content)
		header_alias = @header_alias.merge(header_alias_plus)

		# ヘッダーを読み込む（改行までがヘッダー）
		header = {}
		i = 0
		while i < buffers.size && !type.is_space_line(buffers[i])
			line = buffers[i]

			(is_header, key, value) = type.parse_header(line, @subject_separator)
			if is_header then
				(is_format_plugin_header, format_plugin_key) = type.parse_format_plugin_header(key)
				if is_format_plugin_header then
					if header[M2W_FORMAT_PLUGIN_CONF_HEADER_NAME] == nil then
						header[M2W_FORMAT_PLUGIN_CONF_HEADER_NAME] = {}
					end
					header[M2W_FORMAT_PLUGIN_CONF_HEADER_NAME][format_plugin_key] = value
				else
					if header_alias.has_key?(key) then
						header[key] = value
						header[header_alias[key]] = value
					else
						header[key] = value
					end

					short_key = header_alias.rassoc(key)
					if short_key != nil then
						header[short_key[0]] = value
					end
				end
			else
				break
			end

			i = i + 1
		end

		# 空行を読み飛ばす
		while i < buffers.size && type.is_space_line(buffers[i])
			i = i + 1
		end

		# 本文を読み込む
		contents_name = 'description'
		contents = {contents_name => ''}
		content = ''
		while i < buffers.size
			content << buffers[i]
			content << "\n"

			(is_separating, separating_contents_name) = type.parse_subject_separation(buffers[i], @subject_separator)
			if is_separating then
				contents[contents_name] = type.arrange_content(contents[contents_name])
				contents_name = separating_contents_name
				if header_alias.has_key?(contents_name) then
					contents_name = header_alias[contents_name]
				end
				contents[contents_name] = ''
			else
				contents[contents_name] << buffers[i]
				contents[contents_name] << "\n"
			end

			i = i + 1
		end
		contents[contents_name] = type.arrange_content(contents[contents_name])
		content = type.arrange_content(content)

		return [header, content, contents]
	end

	def get_alias_header(header, header_alias)
		if header.kind_of?(Hash) then
			result = {}
			header.each do |key, value|
				if header_alias.has_key?(key) then
					result[header_alias[key]] = value
				else
					result[key] = value
				end
			end
			return result
		elsif header.kind_of?(Array) then
			result = []
			index = 0
			while index < header.size
				key = header[index]
				value = header[index + 1]

				if header_alias.has_key?(key) then
					result[header_alias[key]] = value
				else
					result[key] = value
				end

				index = index + 1
			end
			return result
		end

		return nil
	end

	def __parse_header(buffers, header_alias, type)
		header = {}
		i = 0
		while i < buffers.size && !type.is_space_line(buffers[i])
			line = buffers[i]

			(is_header, key, value) = type.parse_header(line, @subject_separator)
			if is_header then
				(is_format_plugin_header, format_plugin_key) = type.parse_format_plugin_header(key)
				if is_format_plugin_header then
					if header[M2W_FORMAT_PLUGIN_CONF_HEADER_NAME] == nil then
						header[M2W_FORMAT_PLUGIN_CONF_HEADER_NAME] = {}
					end
					header[M2W_FORMAT_PLUGIN_CONF_HEADER_NAME][format_plugin_key] = value
				else
					if header_alias.has_key?(key) then
						header[key] = value
						header[header_alias[key]] = value
					else
						header[key] = value
					end

					short_key = header_alias.rassoc(key)
					if short_key != nil then
						header[short_key[0]] = value
					end
				end
			else
				break
			end

			i = i + 1
		end

		return [header, i]
	end

end
