# coding: UTF-8

if $0 == __FILE__ then
	ROOT_PATH = File.dirname(File.expand_path(__FILE__))

	$:.unshift(ROOT_PATH + "/../../../")
	$:.unshift(ROOT_PATH + "/../../../../main/")
	$:.unshift(ROOT_PATH + "/../../../../main/lib")

	# mail2weblog のルートパスを設定する
	M2W_ROOT_PATH = ROOT_PATH + "/../../../../main/"

	require 'm2w_configurator'
	require 'minitest/autorun'
end

require 'm2w_mail_parser'
require 'm2w_mail_sender'
require 'm2w_plugin_manager'
require 'mailutils/mail_processor'
require 'testutils/accessor'
require 'testutils/image_testutils'
require 'testutils/mail_testutils'
require 'testutils/weblog_testutils'

require "#{File.dirname(File.expand_path(__FILE__))}/../../conf/setting"
require "#{File.dirname(File.expand_path(__FILE__))}/conf/setting"

#=ブログ記事取得コマンドプラグインのテスト
#
# リアル投稿テストです。実在するブログに投稿を行い、投稿結果が反映されていることの確認を行います。
# 本テストの内容は、設定（../../conf/setting.rb, conf/setting.rb）によって決定されます。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_get_plugin.rb 779 2012-07-11 03:50:25Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestGetCommandPlugin < MiniTest::Unit::TestCase

	if M2W4TEST_REAL && M2W4TEST_REAL_GET_TEST then
		def setup
			@mail_parser = Mail2WeblogMailParser.new(
				M2W_SUBJECT_HEADER,
				M2W_SUBJECT_SEPARATOR_REGEX,
				{})

			@mail_sender = Mail2WeblogMailSender.new(
				M2W4TEST_SENDER_SMTP_SERVER_ADDRESS,
				M2W4TEST_SENDER_SMTP_SERVER_PORT,
				M2W4TEST_SENDER_SMTP_SECURITY_TYPE,
				M2W4TEST_SENDER_SMTP_SERVER_USER,
				M2W4TEST_SENDER_SMTP_SERVER_PASSWORD,
				M2W4TEST_SENDER_POP3_BEFORE_SMTP_SERVER_ADDRESS,
				M2W4TEST_SENDER_POP3_BEFORE_SMTP_SERVER_PORT,
				M2W4TEST_SENDER_POP3_BEFORE_SMTP_SERVER_USER,
				M2W4TEST_SENDER_POP3_BEFORE_SMTP_SERVER_PASSWORD,
				M2W_SUBJECT_HEADER,
				M2W_SUBJECT_SEPARATOR,
				MailProcessor.parse_mail_address(M2W4TEST_REPLY_MAILADDRESS),
				true)

			@plugin_manager = Mail2WeblogPluginManager.new(
				{},
				{},
				{'COMMON' =>
					{'default_format_mode' => 'wiki'}
				}
			)

			@mail_testutils = MailTestUtils.new(
				M2W4TEST_SENDER_SMTP_SERVER_ADDRESS,
				M2W4TEST_SENDER_SMTP_SERVER_PORT,
				M2W4TEST_SENDER_SMTP_SECURITY_TYPE,
				M2W4TEST_SENDER_SMTP_SERVER_USER,
				M2W4TEST_SENDER_SMTP_SERVER_PASSWORD,
				M2W4TEST_SENDER_POP3_SERVER_ADDRESS,
				M2W4TEST_SENDER_POP3_SERVER_PORT,
				M2W4TEST_SENDER_POP3_SERVER_USER,
				M2W4TEST_SENDER_POP3_SERVER_PASSWORD,
				M2W_SYSTEM_INNER_ENCODING)
			@mail_testutils.delete_all()

			@weblog_testutils = WeblogTestUtils.new(
				M2W4TEST_WEBLOG_EXTENSION,
				@mail_parser,
				@mail_sender,
				Mail2WeblogPluginManager.new(),
				@mail_testutils,
				M2W4TEST_SENDER_MAILADDRESS,
				M2W4TEST_REPLY_MAILADDRESS)
		end

		def test_simple
			M2W_LOGGER.debug("Start  #{self.class.name}#test_simple")

			# 期待値を用意する
			from_address = MailAddress.new(M2W4TEST_SENDER_MAILADDRESS)
			to_addresses = [MailAddress.new(M2W4TEST_REPLY_MAILADDRESS)]
			keyword = Time.now.strftime("%Yテ%mス%dト%Hマ%Mー%Sク")
			title = "タイトルテスト@#{keyword}"
			attr1 = "属性１@#{keyword}"
			attr2 = "属性２@#{keyword}"
			message = "コンテンツテスト１行目@#{keyword}\n\nコンテンツテスト２行目@#{keyword}"

			# 編集元のブログ記事を投稿する
			(post_result, mail, postid, attachment_urls) = @weblog_testutils.post(
				M2W4TEST_WEBLOG_BLOG_ID,
				{
					'tit' => title,
					'attr1' => attr1,
					'attr2' => attr2,
				},
				message)

			# コマンドを実行する
			blogid = M2W4TEST_WEBLOG_BLOG_ID != M2W_WEBLOG_DEFAULT_BLOGID ? M2W4TEST_WEBLOG_BLOG_ID : nil
			content = @mail_sender.make_content({"postid" => postid}, nil)
			mail = Mail.new(@mail_sender.make_title("get", blogid), from_address, to_addresses, content, [])
			command = Get_CommandPlugin.new
			command.weblog = M2W4TEST_WEBLOG_EXTENSION
			command.mail_parser = @mail_parser
			command.mail_sender = @mail_sender
			command.plugin_manager = @plugin_manager
			command.mail = mail
			command.param = blogid
			assert command.run()
			assert command.report[:original_content] != nil
			(header, content) = @mail_parser.parse_content(command.report[:original_content], {})
			assert_equal 3, header.size
			assert_equal title, header['tit']
			assert_equal attr1, header['attr1']
			assert_equal attr2, header['attr2']
			assert_equal message, content
			assert_equal postid.to_s, command.report[:postid]
			assert_equal 0, command.report[:attachments].size
			assert command.report[:link] != nil
			assert_equal 0, command.report[:errors].size
			assert_equal 0, command.report[:warnings].size

			# メールの受信を確認する
			mail = @mail_testutils.get_mail()
			assert mail != nil
			assert_equal @mail_sender.make_title("edit", blogid), mail.subject
			assert_equal M2W4TEST_REPLY_MAILADDRESS, mail.from_address.address
			assert_equal 1, mail.to_addresses.size
			assert_equal from_address.address, mail.to_addresses[0].address
			(mail_header, mail_content) = @mail_parser.parse_content(mail.content, {})
			assert_equal 4, mail_header.size
			assert_equal postid.to_s, mail_header['postid']
			assert_nil mail_header['blogid']
			assert_equal title, mail_header['tit']
			assert_equal attr1, mail_header['attr1']
			assert_equal attr2, mail_header['attr2']
			assert_equal content, mail_content
			assert_equal 0, mail.attachments.size

			M2W_LOGGER.debug("Finish #{self.class.name}#test_simple")
		end

		if M2W4TEST_REAL_ATTACHMENTS_TEST then
			def test_attachments
				M2W_LOGGER.debug("Start  #{self.class.name}#test_attachments")

				# 期待値を用意する
				from_address = MailAddress.new(M2W4TEST_SENDER_MAILADDRESS)
				to_addresses = [MailAddress.new(M2W4TEST_REPLY_MAILADDRESS)]
				keyword = Time.now.strftime("%Yテ%mス%dト%Hマ%Mー%Sク")
				title = "タイトルテスト@#{keyword}"
				message = "コンテンツテスト@#{keyword}"
				attachments = M2W4TEST_REAL_ATTACHMENTS_ACTUAL

				# 取得元のブログ記事を投稿する
				(post_result, mail, postid, attachment_urls) = @weblog_testutils.post(
					M2W4TEST_WEBLOG_BLOG_ID,
					{"tit" => title},
					M2W4TEST_REAL_THUMBNAIL_MESSAGES == nil ? message : message + M2W4TEST_REAL_THUMBNAIL_MESSAGES,
					attachments)

				# コマンドを実行する
				mail_content = @mail_sender.make_content({"postid" => postid}, nil)
				mail = Mail.new(@mail_sender.make_title("get", M2W4TEST_WEBLOG_BLOG_ID), from_address, to_addresses, mail_content, [])
				command = Get_CommandPlugin.new
				command.weblog = M2W4TEST_WEBLOG_EXTENSION
				command.mail_parser = @mail_parser
				command.mail_sender = @mail_sender
				command.plugin_manager = @plugin_manager
				command.mail = mail
				command.param = M2W4TEST_WEBLOG_BLOG_ID
				assert command.run()
				assert command.report[:original_content] != nil
				(header, content) = @mail_parser.parse_content(command.report[:original_content], {})
				assert_equal 1, header.size
				assert_equal title, header['tit']
				assert_equal M2W4TEST_REAL_THUMBNAIL_MESSAGES == nil ? message : message + M2W4TEST_REAL_THUMBNAIL_MESSAGES, content
				assert_equal postid.to_s, command.report[:postid]
				assert command.report[:attachments] != nil
				assert command.report[:link] != nil
				assert_equal 0, command.report[:errors].size
				assert_equal 0, command.report[:warnings].size

				# メールの受信を確認する
				mail = @mail_testutils.get_mail()
				assert mail != nil
				assert_equal @mail_sender.make_title("edit", M2W4TEST_WEBLOG_BLOG_ID), mail.subject
				assert_equal M2W4TEST_REPLY_MAILADDRESS, mail.from_address.address
				assert_equal 1, mail.to_addresses.size
				assert_equal from_address.address, mail.to_addresses[0].address
				(mail_header, mail_content) = @mail_parser.parse_content(mail.content, {})
				assert_equal 2, mail_header.size
				assert_equal postid.to_s, mail_header['postid']
				assert_nil mail_header['blogid']
				assert_equal title, mail_header['tit']
				assert_equal content, mail_content
				if M2W4TEST_REAL_ATTACHMENTS_ACTUAL != nil && M2W4TEST_REAL_ATTACHMENTS_EXPECTED != nil then
					assert_equal M2W4TEST_REAL_ATTACHMENTS_EXPECTED.clone.delete_if{|attachment| attachment == nil}.size, command.report[:attachments].clone.delete_if{|attachment| attachment == nil}.size
					i = 0
					while i < M2W4TEST_REAL_ATTACHMENTS_EXPECTED.size
						M2W_LOGGER.debug("attachment index: #{i}")

						if M2W4TEST_REAL_ATTACHMENTS_EXPECTED[i] != nil then
							if /^image/ =~ Mime.new.mime(M2W4TEST_REAL_ATTACHMENTS_EXPECTED[i].filename) then
								expected = Magick::Image.from_blob(M2W4TEST_REAL_ATTACHMENTS_EXPECTED[i].content).shift
								actual = Magick::Image.from_blob(command.report[:attachments][i].content).shift
								assert ImageTestUtils.nearly_identical?(expected, actual)
							else
								assert_equal M2W4TEST_REAL_ATTACHMENTS_EXPECTED[i].content, command.report[:attachments][i].content
							end
						else
							assert_nil command.report[:attachments][i]
						end

						i = i + 1
					end
				end

				M2W_LOGGER.debug("Finish #{self.class.name}#test_attachments")
			end
		end
	end

end
