# coding: UTF-8

require 'plugin/command/adapter/mail/lib/standard_command_adapter4mail'

#=ブログ記事取得コマンドアダプタープラグイン（メール用）
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: get.rb 895 2012-12-18 10:26:47Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Get_CommandAdapterPlugin4Mail < Standard_CommandAdapterPlugin4Mail

	attr_writer :mail_parser

	def create_request(command, mail)
		subject_parsed_result = @mail_parser.parse_subject(mail.escaped_prefix_subject)
		param = subject_parsed_result ? subject_parsed_result[1] : nil

		content = @mail_parser.escaped_prefix_content(mail.content, 'postid\.')
		(header, content, contents) = @mail_parser.parse_content(content, command.header_alias())
		param = header['blogid'] if header.has_key?('blogid')

		return Mail2WeblogRequest.new(
			:source => mail.from_address.address,
			:param => param,
			:header => header)
	end

	def create_response(command, request, response)
		return response.success ? create_success_response(command, request, response) : create_failure_response(command, request, response)
	end

	def create_success_response(command, request, response)
		(header, content) = @mail_parser.parse_content(response[:original_content], {}, __parser(response[:mode]))
		header.merge!(response[:additional_header]) if response[:additional_header]
		header_with_postid = __get_header_with_postid(header, request.header['postid'])

		response.notices.push(Mail2WeblogResponseNotice.new(
			:destination => request.source,
			:format => response[:mode],
			:type => 'edit',
			:param => request.param,
			:header => header_with_postid,
			:content => content,
			:attachments => response[:attachments].clone.delete_if{|attachment| attachment == nil},
			:related_attachments => response[:related_attachments].clone.delete_if{|related_attachment| related_attachment == nil}
		))
		return response
	end

	def create_failure_response(command, request, response)
content = <<"END_CONTENT"
ブログ記事の取得に失敗しました。
#{make_exception_contents(response)}
END_CONTENT

		response.notices.push(Mail2WeblogResponseNotice.new(
			:destination => request.source,
			:type => 'error',
			:param => request.param,
			:content => content
		))
		return response
	end

	def __get_header_with_postid(header, postid)
		result = ['postid', postid]

		unnecessary_header_keys = {'postid' => true, 'blogid' => true}

		if header.kind_of?(Hash) then
			header.each do |key, value|
				if !unnecessary_header_keys.has_key?(key) then
					result.push(key)
					result.push(value)
				end
			end
		elsif header.kind_of?(Array) then
			i = 0
			while i < header.size
				key   = header[i + 0]
				value = header[i + 1]
				if !unnecessary_header_keys.has_key?(key) then
					result.push(key)
					result.push(value)
				end

				i = i + 2
			end
		end

		return result
	end

	def __parser(mode)
		case mode
		when 'wiki', 'htmlplain'
			return Mail2WeblogMailParserPlainTextType.new
		when 'html'
			return Mail2WeblogMailParserHtmlTextType.new
		end
	end

end
