# coding: UTF-8

require 'blogger/blogger'
require 'plugin/weblog/movable_type/movable_type_post.rb'

#=Goo ブログのためのブログ記事投稿用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: goo_post.rb 895 2012-12-18 10:26:47Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class GooPost_WeblogPlugin < MovableTypePost_WeblogPlugin

	def header_alias
		result = super
		return result.merge(@parent.header_alias_for_post)
	end

	def parse_postid(postid)
		return postid.split[0]
	end

	alias :__post_temp_article post_temp_article
	alias :__repost_formatted_article repost_formatted_article
	alias :__delete_temp_article delete_temp_article

	def post_temp_article(client, blogid)
		error_count = 0
		while true
			begin
				return __post_temp_article(client, blogid)
			rescue XMLRPC::FaultException => e
				@logger.error("XML-RPC の操作に失敗したのでリトライします。 ... #{error_count}") if @logger != nil && @logger.error?
				@logger.error(e) if @logger != nil && @logger.error?
				sleep 1
				error_count = error_count + 1
				raise e if 10 <= error_count
			end
		end
	end

	def repost_formatted_article(client, blogid, postid, header, dateCreated)
		error_count = 0
		while true
			begin
				return __repost_formatted_article(client, blogid, postid, header, dateCreated)
			rescue XMLRPC::FaultException => e
				@logger.error("XML-RPC の操作に失敗したのでリトライします。 ... #{error_count}") if @logger != nil && @logger.error?
				@logger.error(e) if @logger != nil && @logger.error?
				sleep 1
				error_count = error_count + 1
				raise e if 10 <= error_count
			end
		end
	end

	def delete_temp_article(client, blogid, postid)
		error_count = 0
		while true
			begin
				return __delete_temp_article(client, blogid, postid)
			rescue XMLRPC::FaultException => e
				@logger.error("XML-RPC の操作に失敗したのでリトライします。 ... #{error_count}") if @logger != nil && @logger.error?
				@logger.error(e) if @logger != nil && @logger.error?
				sleep 1
				error_count = error_count + 1
				raise e if 10 <= error_count
			end
		end
	end

	def after(client, request, response)
		super

		request_trackback(client, request.header, response[:blogid], response[:postid], response[:formatted_contents]['description'])
	end

end
