# coding: UTF-8

require 'plugin/weblog/lib/attachment_media_poster'
require 'plugin/weblog/lib/related_media_poster'
require 'plugin/weblog/lib/standard_command'
require 'plugin/weblog/lib/weblog_plugin_error'
require 'plugin/weblog/lib/weblog_plugin_warning'

#=標準のブログ記事投稿用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: standard_post.rb 895 2012-12-18 10:26:47Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class StandardPost_WeblogPlugin < StandardCommand_WeblogPlugin

	def post(request)
		@logger.debug("Start  #{self.class.name}#post ... header = #{request.header.keys}") if @logger && @logger.debug?

		client = @parent.client
		formatter = @parent.formatter
		formatter.logger = @logger
		postid = nil
		response = Mail2WeblogResponse.new

		begin
			blogid = @parent.respond_to?('transform_blogid') ? @parent.transform_blogid(request, request.param) : request.param

			before(client, request, response)

			# ブログ記事を仮投稿する
			begin
				postid = post_temp_article(client, blogid)
			rescue => e
				@logger.error("ブログ記事の仮投稿に失敗しました。") if @logger
				@logger.error(e) if @logger
				response.errors.push(WeblogPluginError.new(
					"ブログ記事仮投稿エラー(メッセージ = #{e.message})",
					"ブログ記事の仮投稿に失敗しました(メッセージ = #{e.message})。"))
				@logger.debug("Finish #{self.class.name}#post ... result = false") if @logger && @logger.debug?
				return response
			end

			vars = {
				:blogid => blogid,
				:encoding => @parent.encoding,
				M2W_FORMAT_PLUGIN_CONF_HEADER_NAME => request.header[M2W_FORMAT_PLUGIN_CONF_HEADER_NAME]
			}
			vars.merge!(request.header)

			# 書式プラグインの事前処理を行う
			formatter.preset(request, vars, response.errors, response.warnings)

			# 投稿日付を取得する
			header = request.header.clone
			dateCreated = @parent.parse_date(header['dateCreated'], Time.now, response.errors, response.warnings)
			if header['dateCreated'] != nil then
				header['dateCreated'] = @parent.get_date(dateCreated)
			end

			# ファイル転送の事前準備をする
			media_posters = []
			# 添付ファイルを投稿対象に追加する
			if request.attachments != nil then
				request.attachments.each_with_index do |attachment, i|
					attachment_index = i + 1
					media_name = @parent.get_attachment_filepath(postid, dateCreated, attachment_index, attachment.filename)
					thumbnail_name = @parent.get_thumbnail_filepath(postid, dateCreated, attachment_index, attachment.filename)
					media_posters.push(AttachmentMediaPoster.new(attachment, attachment_index, media_name, thumbnail_name, vars))
				end
			end
			# 関連ファイルを投稿対象に追加する
			if request.related_attachments != nil then
				request.related_attachments.each_with_index do |related_attachment, i|
					related_attachment_index = i + 1
					media_name = "rel#{postid}_#{related_attachment_index}#{File.extname(related_attachment.filename)}"
					thumbnail_name = "relthumbs#{postid}_#{related_attachment_index}#{File.extname(related_attachment.filename)}"
					media_posters.push(RelatedMediaPoster.new(related_attachment, media_name, thumbnail_name, @parent.plugin_manager, vars))
				end
			end
			# 書式プラグインからのファイル転送指令を投稿対象に追加する
			if vars[M2W_FORMAT_PLUGIN_CONF_HEADER_NAME] && vars[M2W_FORMAT_PLUGIN_CONF_HEADER_NAME][M2W_WEBLOG_PLUGIN_CONF_MEDIAS_VAR_NAME] then
				vars[M2W_FORMAT_PLUGIN_CONF_HEADER_NAME][M2W_WEBLOG_PLUGIN_CONF_MEDIAS_VAR_NAME].each do |media_name, media|
					media_posters.push(media)
				end
			end

			# ファイルを転送する
			vars[:attachment_urls] = {}
			vars[:thumbnail_urls] = {}
			vars[:related_attachment_urls] = {}
			vars[:related_thumbnail_urls] = {}
			post_medias(client, @parent.username, @parent.password, blogid, media_posters, response.errors, response.warnings)

			# 書式変換を行う
			formatted_contents = nil
			begin
				formatted_contents = formatter.format(request, vars, response.errors, response.warnings)
				header.merge!(formatted_contents)
			rescue => e
				@logger.error("ブログ記事の書式変換に失敗しました。") if @logger
				@logger.error(e) if @logger
				raise e
			end

			# 書式変換した結果を再投稿する
			begin
				repost_formatted_article(client, blogid, postid, header, dateCreated)
			rescue => e
				@logger.error("ブログ記事の書式変換後の投稿に失敗しました。") if @logger
				@logger.error(e) if @logger
				raise e
			end

			response[:original_content] = request.original_content
			response[:blogid] = blogid
			response[:postid] = postid
			response[:attachment_urls] = vars[:attachment_urls]
			response[:thumbnail_urls] = vars[:thumbnail_urls]
			response[:title] = header['title']
			response[:formatted_contents] = formatted_contents

			after(client, request, response)
		rescue => e
			@logger.error("ブログ記事の投稿に失敗しました。") if @logger
			@logger.error(e) if @logger
			response.errors.push(WeblogPluginError.new(
				"ブログ記事投稿エラー(投稿ＩＤ = #{postid}, メッセージ = #{e.message})",
				"ブログ記事の投稿に失敗しました。仮投稿したブログ記事の削除を試みます(投稿ＩＤ = #{postid}, メッセージ = #{e.message})。"))
			begin
				if postid != nil then
					delete_temp_article(client, blogid, postid)
					response.errors.push(WeblogPluginError.new(
						"仮投稿ブログ記事削除済み(投稿ＩＤ = #{postid})",
						"仮投稿ブログ記事の削除に成功しました。ブログ記事を再投稿するには投稿内容を再確認してください(投稿ＩＤ = #{postid})。"))
				end
			rescue => e
				@logger.error("ブログ記事の削除に失敗しました。") if @logger
				@logger.error(e) if @logger
				response.errors.push(WeblogPluginError.new(
					"仮投稿ブログ記事削除エラー(投稿ＩＤ = #{postid}, メッセージ = #{e.message})",
					"仮投稿ブログ記事の削除に失敗しました。該当のブログ記事を手動で削除してください(投稿ＩＤ = #{postid}, メッセージ = #{e.message})。"))
			end

			@logger.debug("Finish #{self.class.name}#post ... result = false") if @logger && @logger.debug?
			return response
		end

		@logger.debug("Finish #{self.class.name}#post ... result = true") if @logger && @logger.debug?
		response.success = true
		return response
	end

	def header_alias
		return M2W_WEBLOG_POST_HEADER_ALIAS
	end

	def before(client, request, response)
	end

	def after(client, request, response)
	end

	def post_temp_article(client)
		raise WeblogPluginError.new(
			"未実装エラー",
			"実装されていません。")
	end

	def repost_formatted_article(client, blogid, postid, header, dateCreated)
		raise WeblogPluginError.new(
			"未実装エラー",
			"実装されていません。")
	end

	def delete_temp_article(client, blogid, postid)
		raise WeblogPluginError.new(
			"未実装エラー",
			"実装されていません。")
	end

	def parse_postid(source)
		raise WeblogPluginError.new(
			"未実装エラー",
			"実装されていません。")
	end

end
