# coding: UTF-8

if $0 == __FILE__ then
	ROOT_PATH = File.dirname(File.expand_path(__FILE__))

	$:.unshift(ROOT_PATH + "/../")
	$:.unshift(ROOT_PATH + "/../../main/")
	$:.unshift(ROOT_PATH + "/../../main/lib/")

	# mail2weblog のルートパスを設定する
	M2W_ROOT_PATH = ROOT_PATH + "/../../main/"

	require 'm2w_configurator'
	require 'minitest/autorun'
end

require 'm2w_plugin_manager'
require 'style/formatter'
require 'plugin/format/lib/format_plugin_utils'

class Example_FormatPlugin
	include FormatPluginUtils

	def plugin_contents(param, vars)
		(params, option, content) = get_format_plugin_parameter(param, vars, 0)

		if option['type'] != nil then
			case option['type']
			when "warning"
				raise FormatPluginWarning.new("warning", "warning")
			when "error"
				raise FormatPluginError.new("error", "error")
			end
		else
			if content == nil then
				return "example"
			else
				return "example[#{content}]"
			end
		end
	end

	def plugin_contents_inline(param, vars)
		(params, option, content) = get_format_plugin_parameter(param, vars, 0)

		if option['type'] != nil then
			case option['type']
			when "warning"
				raise FormatPluginWarning.new("warning_inline", "warning_inline")
			when "error"
				raise FormatPluginError.new("error_inline", "error_inline")
			end
		else
			if content == nil then
				return "example_inline"
			else
				return "example_inline[#{content}]"
			end
		end
	end

end

#=Formatter のテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_formatter_htmlplain.rb 895 2012-12-18 10:26:47Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestFormatter4HTMLPlain < MiniTest::Unit::TestCase

	def setup
		@formatter = Formatter.new(Mail2WeblogPluginManager.new({}, {}, {'COMMON' => {'default_format_mode' => 'html'}}))
	end

	def test_format
original_content = <<"END_CONTENT"
tit.タイトル <&>

１行目
２行目
END_CONTENT

content = <<"END_CONTENT"
１行目
２行目
END_CONTENT

		contents = {
			'description' => content
		}

		request = Mail2WeblogRequest.new(
			:format => 'htmlplain',
			:original_content => original_content,
			:content => content,
			:contents => contents)

expected_description = <<"END_CONTENT"
<!--m2w_version:#{M2W_VERSION}--><!--[htmlplain] tit.タイトル &lt;&amp;&gt;

１行目
２行目
 --><p>１行目</p>
<p>２行目</p>
END_CONTENT

		errors = []
		warnings = []

		result = @formatter.format(request, {}, errors, warnings)

		assert_equal 1, result.size
		assert_equal expected_description, result['description']
		assert_equal 0, errors.size
		assert_equal 0, warnings.size
	end

	def test_format_with_plugin
		original_content = "{{example}}"
		content = original_content
		contents = {
			'description' => content
		}

		request = Mail2WeblogRequest.new(
			:format => 'htmlplain',
			:original_content => original_content,
			:content => content,
			:contents => contents)

expected_description = <<"END_CONTENT"
<!--m2w_version:#{M2W_VERSION}--><!--[htmlplain] {{example}} --><p>example</p>
END_CONTENT

		errors = []
		warnings = []

		result = @formatter.format(request, {}, errors, warnings)

		assert_equal 1, result.size
		assert_equal expected_description, result['description']
		assert_equal 0, errors.size
		assert_equal 0, warnings.size
	end

	def test_format_multiline_with_plugin
original_content = <<"END_CONTENT"
{{example
line1
line2}}
END_CONTENT

		content = original_content
		contents = {
			'description' => content
		}

		request = Mail2WeblogRequest.new(
			:format => 'htmlplain',
			:original_content => original_content,
			:content => content,
			:contents => contents)

expected_description = <<"END_CONTENT"
<!--m2w_version:#{M2W_VERSION}--><!--[htmlplain] {{example
line1
line2}}
 --><p>example[line1
line2]</p>
END_CONTENT

		errors = []
		warnings = []

		result = @formatter.format(request, {}, errors, warnings)

		assert_equal 1, result.size
		assert_equal expected_description, result['description']
		assert_equal 0, errors.size
		assert_equal 0, warnings.size
	end

	def test_format_with_plugin_warning
		original_content = "{{example(type@warning)}}"
		content = original_content
		contents = {
			'description' => content
		}

		request = Mail2WeblogRequest.new(
			:format => 'htmlplain',
			:original_content => original_content,
			:content => content,
			:contents => contents)

expected_description = <<"END_CONTENT"
<!--m2w_version:#{M2W_VERSION}--><!--[htmlplain] {{example(type@warning)}} --><p>{{警告: warning}}</p>
END_CONTENT

		errors = []
		warnings = []

		result = @formatter.format(request, {}, errors, warnings)

		assert_equal 1, result.size
		assert_equal expected_description, result['description']
		assert_equal 0, errors.size
		assert_equal 1, warnings.size
	end

	def test_format_with_plugin_error
		original_content = "{{example(type@error)}}"
		content = original_content
		contents = {
			'description' => content
		}

		request = Mail2WeblogRequest.new(
			:format => 'htmlplain',
			:original_content => original_content,
			:content => content,
			:contents => contents)

expected_description = <<"END_CONTENT"
<!--m2w_version:#{M2W_VERSION}--><!--[htmlplain] {{example(type@error)}} --><p>{{エラー: error}}</p>
END_CONTENT

		errors = []
		warnings = []

		result = @formatter.format(request, {}, errors, warnings)

		assert_equal 1, result.size
		assert_equal expected_description, result['description']
		assert_equal 1, errors.size
		assert_equal 0, warnings.size
	end

	def test_format_with_plugin_inline
		original_content = "テスト{{example}}"
		content = original_content
		contents = {
			'description' => content
		}

		request = Mail2WeblogRequest.new(
			:format => 'htmlplain',
			:original_content => original_content,
			:content => content,
			:contents => contents)

expected_description = <<"END_CONTENT"
<!--m2w_version:#{M2W_VERSION}--><!--[htmlplain] テスト{{example}} --><p>テストexample_inline</p>
END_CONTENT

		errors = []
		warnings = []

		result = @formatter.format(request, {}, errors, warnings)

		assert_equal 1, result.size
		assert_equal expected_description, result['description']
		assert_equal 0, errors.size
		assert_equal 0, warnings.size
	end

	def test_format_multiline_with_plugin_inline
original_content = <<"END_CONTENT"
テスト{{example
line1
line2}}
END_CONTENT

		content = original_content
		contents = {
			'description' => content
		}

		request = Mail2WeblogRequest.new(
			:format => 'htmlplain',
			:original_content => original_content,
			:content => content,
			:contents => contents)

expected_description = <<"END_CONTENT"
<!--m2w_version:#{M2W_VERSION}--><!--[htmlplain] テスト{{example
line1
line2}}
 --><p>テストexample_inline[line1
line2]</p>
END_CONTENT

		errors = []
		warnings = []

		result = @formatter.format(request, {}, errors, warnings)

		assert_equal 1, result.size
		assert_equal expected_description, result['description']
		assert_equal 0, errors.size
		assert_equal 0, warnings.size
	end

	def test_format_with_plugin_inline_warning
		original_content = "テスト{{example(type@warning)}}"
		content = original_content
		contents = {
			'description' => content
		}

		request = Mail2WeblogRequest.new(
			:format => 'htmlplain',
			:original_content => original_content,
			:content => content,
			:contents => contents)

expected_description = <<"END_CONTENT"
<!--m2w_version:#{M2W_VERSION}--><!--[htmlplain] テスト{{example(type@warning)}} --><p>テスト{{警告: warning_inline}}</p>
END_CONTENT

		errors = []
		warnings = []

		result = @formatter.format(request, {}, errors, warnings)

		assert_equal 1, result.size
		assert_equal expected_description, result['description']
		assert_equal 0, errors.size
		assert_equal 1, warnings.size
	end

	def test_format_with_plugin_inline_error
		original_content = "テスト{{example(type@error)}}"
		content = original_content
		contents = {
			'description' => content
		}

		request = Mail2WeblogRequest.new(
			:format => 'htmlplain',
			:original_content => original_content,
			:content => content,
			:contents => contents)

expected_description = <<"END_CONTENT"
<!--m2w_version:#{M2W_VERSION}--><!--[htmlplain] テスト{{example(type@error)}} --><p>テスト{{エラー: error_inline}}</p>
END_CONTENT

		errors = []
		warnings = []

		result = @formatter.format(request, {}, errors, warnings)

		assert_equal 1, result.size
		assert_equal expected_description, result['description']
		assert_equal 1, errors.size
		assert_equal 0, warnings.size
	end

	def test_format_with_plugin_inline_warning
		original_content = "テスト{{example(type@warning)}}"
		content = original_content
		contents = {
			'description' => content
		}

		request = Mail2WeblogRequest.new(
			:format => 'htmlplain',
			:original_content => original_content,
			:content => content,
			:contents => contents)

expected_description = <<"END_CONTENT"
<!--m2w_version:#{M2W_VERSION}--><!--[htmlplain] テスト{{example(type@warning)}} --><p>テスト{{警告: warning_inline}}</p>
END_CONTENT

		errors = []
		warnings = []

		result = @formatter.format(request, {}, errors, warnings)

		assert_equal 1, result.size
		assert_equal expected_description, result['description']
		assert_equal 0, errors.size
		assert_equal 1, warnings.size
	end

	def test_format_with_plugins
original_content = <<"END_CONTENT"
テスト{{example}}
{{example}}
{{example
END_CONTENT

		content = original_content
		contents = {
			'description' => content
		}

		request = Mail2WeblogRequest.new(
			:format => 'htmlplain',
			:original_content => original_content,
			:content => content,
			:contents => contents)

expected_description = <<"END_CONTENT"
<!--m2w_version:#{M2W_VERSION}--><!--[htmlplain] テスト{{example}}
{{example}}
{{example
 --><p>テストexample_inline</p>
<p>example</p>
<p>{{example</p>
END_CONTENT

		errors = []
		warnings = []

		result = @formatter.format(request, {}, errors, warnings)

		assert_equal 1, result.size
		assert_equal expected_description, result['description']
		assert_equal 0, errors.size
		assert_equal 0, warnings.size
	end

	def test_get_uncommentout_content
content = <<"END_CONTENT"
<!--m2w_version:#{M2W_VERSION}--><!--[htmlplain] tit.タイトル &lt;&amp;&gt;

１行目
２行目 --><div>１行目</div><div>２行目</div>
END_CONTENT

expected_content = <<"END_CONTENT"
tit.タイトル <&>

１行目
２行目
END_CONTENT

		(version, content, type) = @formatter.get_uncommentout_content(content)
		assert_equal M2W_VERSION, version
		assert_equal expected_content.chomp, content
		assert_equal 'htmlplain', type
	end

end
