# coding: UTF-8

if $0 == __FILE__ then
	ROOT_PATH = File.dirname(File.expand_path(__FILE__))

	$:.unshift(ROOT_PATH + "/../")
	$:.unshift(ROOT_PATH + "/../../main/")
	$:.unshift(ROOT_PATH + "/../../main/lib")

	# mail2weblog のルートパスを設定する
	M2W_ROOT_PATH = ROOT_PATH + "/../../main/"

	require 'm2w_configurator'
	require 'minitest/autorun'
end

require 'm2w_mail_parser'
require 'm2w_mail_sender'
require 'm2w_plugin_manager'
require 'm2w_runner'
require 'mailutils/mail_processor'
require 'testutils/mail_testutils'
require 'testutils/weblog_testutils'

require File.expand_path("#{File.dirname(File.expand_path(__FILE__))}/conf/setting")

require 'open-uri'
require 'yaml'

#=mail2weblog のテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_m2w_runner.rb 895 2012-12-18 10:26:47Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestMail2Weblog < MiniTest::Unit::TestCase

	if M2W4TEST_REAL then
		def setup
			@mail_parser = Mail2WeblogMailParser.new(
				M2W_SUBJECT_HEADER,
				M2W_SUBJECT_SEPARATOR_REGEX,
				{})

			@mail_sender = Mail2WeblogMailSender.new(
				M2W4TEST_SENDER_SMTP_SERVER_ADDRESS,
				M2W4TEST_SENDER_SMTP_SERVER_PORT,
				M2W4TEST_SENDER_SMTP_SECURITY_TYPE,
				M2W4TEST_SENDER_SMTP_SERVER_USER,
				M2W4TEST_SENDER_SMTP_SERVER_PASSWORD,
				M2W4TEST_SENDER_POP3_BEFORE_SMTP_SERVER_ADDRESS,
				M2W4TEST_SENDER_POP3_BEFORE_SMTP_SERVER_PORT,
				M2W4TEST_SENDER_POP3_BEFORE_SMTP_SERVER_USER,
				M2W4TEST_SENDER_POP3_BEFORE_SMTP_SERVER_PASSWORD,
				M2W_SUBJECT_HEADER,
				M2W_SUBJECT_SEPARATOR,
				MailProcessor.parse_mail_address(M2W4TEST_REPLY_MAILADDRESS),
				true)

			@mail_testutils = MailTestUtils.new(
				M2W4TEST_SENDER_SMTP_SERVER_ADDRESS,
				M2W4TEST_SENDER_SMTP_SERVER_PORT,
				M2W4TEST_SENDER_SMTP_SECURITY_TYPE,
				M2W4TEST_SENDER_SMTP_SERVER_USER,
				M2W4TEST_SENDER_SMTP_SERVER_PASSWORD,
				M2W4TEST_SENDER_POP3_SERVER_ADDRESS,
				M2W4TEST_SENDER_POP3_SERVER_PORT,
				M2W4TEST_SENDER_POP3_SERVER_USER,
				M2W4TEST_SENDER_POP3_SERVER_PASSWORD,
				M2W_SYSTEM_INNER_ENCODING)

			@weblog_testutils = WeblogTestUtils.new(
				M2W4TEST_WEBLOG_EXTENSION,
				@mail_parser,
				@mail_sender,
				Mail2WeblogPluginManager.new(),
				@mail_testutils,
				M2W4TEST_SENDER_MAILADDRESS,
				M2W4TEST_REPLY_MAILADDRESS)

			@mail_testutils4runner = MailTestUtils.new(
				nil,
				nil,
				nil,
				nil,
				nil,
				M2W4TEST_POP3_SERVER_ADDRESS,
				M2W4TEST_POP3_SERVER_PORT,
				M2W4TEST_POP3_SERVER_USER,
				M2W4TEST_POP3_SERVER_PASSWORD,
				M2W_SYSTEM_INNER_ENCODING)

			@runner = Mail2WeblogRunner.new(
				M2W4TEST_WEBLOG_EXTENSION,
				nil,
				Mail2WeblogMailSender.new(
					M2W4TEST_SMTP_SERVER_ADDRESS,
					M2W4TEST_SMTP_SERVER_PORT,
					M2W4TEST_SMTP_SECURITY_TYPE,
					M2W4TEST_SMTP_SERVER_USER,
					M2W4TEST_SMTP_SERVER_PASSWORD,
					M2W4TEST_POP3_BEFORE_SMTP_SERVER_ADDRESS,
					M2W4TEST_POP3_BEFORE_SMTP_SERVER_PORT,
					M2W4TEST_POP3_BEFORE_SMTP_SERVER_USER,
					M2W4TEST_POP3_BEFORE_SMTP_SERVER_PASSWORD,
					M2W_SUBJECT_HEADER,
					M2W_SUBJECT_SEPARATOR,
					MailProcessor.parse_mail_address(M2W4TEST_REPLY_MAILADDRESS),
					true
				),
				MailCommandProcessor.new(
					M2W4TEST_POP3_SERVER_ADDRESS,
					M2W4TEST_POP3_SERVER_PORT,
					M2W4TEST_POP3_SERVER_USER,
					M2W4TEST_POP3_SERVER_PASSWORD
				)
			)
		end

		def test_run_simple
			M2W_LOGGER.debug("Start  #{self.class.name}#test_run_simple")

			# 事前にメールボックスを空っぽにする
			@mail_testutils.delete_all()
			@mail_testutils4runner.delete_all

			# メールを送信する（ブログ記事投稿）
			from_address = MailAddress.new(M2W4TEST_SENDER_MAILADDRESS)
			to_addresses = [MailAddress.new(M2W4TEST_REPLY_MAILADDRESS)]
			keyword = Time.now.strftime("%Yテ%mス%dト%Hマ%Mー%Sク")
			title = "タイトルテスト@#{keyword}"
			message = "コンテンツテスト@#{keyword}"
content = <<"END_CONTENT"
tit.#{title}

#{message}
END_CONTENT
			@mail_sender.sendmail(Mail.new(@mail_sender.make_title("post", M2W4TEST_WEBLOG_BLOG_ID), from_address, to_addresses, content, []))

			sleep(M2W4TEST_SLEEP_MINITES_BEFORE_RUNNING_RUNNER)

			# システムを起動する
			@runner.run(M2W_SYSTEM_CONTINOUS_PROCESSING, M2W_SYSTEM_MAIL_RECEIVER_SLEEPING_TIME)

			# メールの受信を確認する
			mail = @mail_testutils.get_mail()
			assert mail != nil
			assert_equal @mail_sender.make_title("get", M2W4TEST_WEBLOG_BLOG_ID), mail.subject
			assert_equal M2W4TEST_REPLY_MAILADDRESS, mail.from_address.address
			assert_equal from_address.name, mail.from_address.name
			assert_equal 1, mail.to_addresses.size
			assert_equal from_address.address, mail.to_addresses[0].address
			(mail_header, mail_content) = @mail_parser.parse_content(mail.content, {})
			assert mail_header.has_key?('postid')
			assert_equal 0, mail.attachments.size

			# ブログの投稿を確認する
			(get_result, mail, header, content, contents, attachments, link) = @weblog_testutils.get(M2W4TEST_WEBLOG_BLOG_ID, mail_header['postid'])
			response = open(link) { |stream| stream.read }.encode(M2W_SYSTEM_INNER_ENCODING, M2W4TEST_WEBLOG_ENCODING)
			assert_match title, response
			assert_match message, response

			# メールを送信する（ブログ記事削除）
			postid = mail_header['postid']
			from_address = MailAddress.new(M2W4TEST_SENDER_MAILADDRESS)
			to_addresses = [MailAddress.new(M2W4TEST_REPLY_MAILADDRESS)]
			content = "postid.#{postid}"
			@mail_sender.sendmail(Mail.new(@mail_sender.make_title("delete", M2W4TEST_WEBLOG_BLOG_ID), from_address, to_addresses, content, []))

			sleep(M2W4TEST_SLEEP_MINITES_BEFORE_RUNNING_RUNNER)

			# システムを起動する
			@runner.run(M2W_SYSTEM_CONTINOUS_PROCESSING, M2W_SYSTEM_MAIL_RECEIVER_SLEEPING_TIME)

			# メールの受信を確認する
			mail = @mail_testutils.get_mail()
			assert mail != nil
			assert_equal @mail_sender.make_title("deleted", M2W4TEST_WEBLOG_BLOG_ID), mail.subject
			assert_equal M2W4TEST_REPLY_MAILADDRESS, mail.from_address.address
			assert_equal from_address.name, mail.from_address.name
			assert_equal 1, mail.to_addresses.size
			assert_equal from_address.address, mail.to_addresses[0].address
			(mail_header, mail_content) = @mail_parser.parse_content(mail.content, {})
			assert mail_header.has_key?('postid'), mail_header.to_s
			assert_equal postid, mail_header['postid'], mail_header.to_s
			assert_equal 0, mail.attachments.size

			M2W_LOGGER.debug("Finish #{self.class.name}#test_run_simple")
		end

		if M2W4TEST_REAL_COMPLEX_M2W_TEST then
			def test_run_complex
				M2W_LOGGER.debug("Start  #{self.class.name}#test_run_complex")

				# 事前にメールボックスを空っぽにする
				@mail_testutils.delete_all()
				@mail_testutils4runner.delete_all

				# メールを送信する
				from_address = MailAddress.new(M2W4TEST_SENDER_MAILADDRESS)
				to_addresses = [MailAddress.new(M2W4TEST_REPLY_MAILADDRESS)]
				keyword = Time.now.strftime("%Yテ%mス%dト%Hマ%Mー%Sク")
				title = "タイトルテスト@#{keyword}"
				message = "コンテンツテスト@#{keyword}"
				content = ""
				content << "tit.#{title}\n"
				if M2W4TEST_REAL_COMPLEX_M2W_DATE_ACTUAL != nil && M2W4TEST_REAL_COMPLEX_M2W_DATE_EXPECTED != nil then
					content << "dat.#{M2W4TEST_REAL_COMPLEX_M2W_DATE_ACTUAL}\n"
				end
				if M2W4TEST_REAL_COMPLEX_M2W_CATS_ACTUAL != nil && M2W4TEST_REAL_COMPLEX_M2W_CATS_EXPECTED != nil then
					content << "cats.#{M2W4TEST_REAL_COMPLEX_M2W_CATS_ACTUAL}\n"
				end
				if M2W4TEST_REAL_COMPLEX_M2W_KEYS_ACTUAL != nil && M2W4TEST_REAL_COMPLEX_M2W_KEYS_EXPECTED != nil then
					content << "keys.#{M2W4TEST_REAL_COMPLEX_M2W_KEYS_ACTUAL}\n"
				end
				if M2W4TEST_REAL_COMPLEX_M2W_TAGS_ACTUAL != nil && M2W4TEST_REAL_COMPLEX_M2W_TAGS_EXPECTED != nil then
					content << "tags.#{M2W4TEST_REAL_COMPLEX_M2W_TAGS_ACTUAL}\n"
				end
				if M2W4TEST_REAL_COMPLEX_M2W_TRACKBACK_RECEIVER_URL != nil && M2W4TEST_REAL_COMPLEX_M2W_TRACKBACK_NOTIFIER_URLS != nil then
					content << "tb.#{M2W4TEST_REAL_COMPLEX_M2W_TRACKBACK_RECEIVER_URL}\n"
				end
				if M2W4TEST_REAL_COMPLEX_M2W_EXCERPT_ACTUAL != nil && M2W4TEST_REAL_COMPLEX_M2W_EXCERPT_EXPECTED != nil then
					content << "excerpt.#{M2W4TEST_REAL_COMPLEX_M2W_EXCERPT_ACTUAL}\n"
				end
				content << "\n"
				content << "#{message}\n"
				if M2W4TEST_REAL_COMPLEX_M2W_MORE_ACTUAL != nil && M2W4TEST_REAL_COMPLEX_M2W_MORE_EXPECTED != nil then
					content << "more....\n"
					content << M2W4TEST_REAL_COMPLEX_M2W_MORE_ACTUAL << "\n"
				end
				@mail_sender.sendmail(Mail.new(@mail_sender.make_title("post", M2W4TEST_WEBLOG_BLOG_ID), from_address, to_addresses, content, []))

				sleep(M2W4TEST_SLEEP_MINITES_BEFORE_RUNNING_RUNNER)

				# システムを起動する
				@runner.run(M2W_SYSTEM_CONTINOUS_PROCESSING, M2W_SYSTEM_MAIL_RECEIVER_SLEEPING_TIME)

				# メールの受信を確認する
				mail = @mail_testutils.get_mail()
				assert mail != nil
				assert_equal @mail_sender.make_title("get", M2W4TEST_WEBLOG_BLOG_ID), mail.subject
				assert_equal M2W4TEST_REPLY_MAILADDRESS, mail.from_address.address
				assert_equal from_address.name, mail.from_address.name
				assert_equal 1, mail.to_addresses.size
				assert_equal from_address.address, mail.to_addresses[0].address
				(mail_header, mail_content) = @mail_parser.parse_content(mail.content, {})
				assert_equal 1, mail_header.size, mail_header.to_s
				assert mail_header.has_key?('postid'), mail_header.to_s
				assert_equal 0, mail.attachments.size

				# ブログの投稿を確認する
				(get_result, mail, header, content, contents, attachments, link) = @weblog_testutils.get(M2W4TEST_WEBLOG_BLOG_ID, mail_header['postid'])
				response = open(link) { |stream| stream.read }.encode(M2W_SYSTEM_INNER_ENCODING, M2W4TEST_WEBLOG_ENCODING)
				assert_match title, response
				if M2W4TEST_REAL_COMPLEX_M2W_DATE_ACTUAL != nil && M2W4TEST_REAL_COMPLEX_M2W_DATE_EXPECTED then
					assert_match M2W4TEST_REAL_COMPLEX_M2W_DATE_EXPECTED, response, "from #{link}"
				end
				if M2W4TEST_REAL_COMPLEX_M2W_CATS_ACTUAL != nil && M2W4TEST_REAL_COMPLEX_M2W_CATS_EXPECTED then
					assert_match M2W4TEST_REAL_COMPLEX_M2W_CATS_EXPECTED, response, "from #{link}"
				end
				if M2W4TEST_REAL_COMPLEX_M2W_KEYS_ACTUAL != nil && M2W4TEST_REAL_COMPLEX_M2W_KEYS_EXPECTED then
					assert_match M2W4TEST_REAL_COMPLEX_M2W_KEYS_EXPECTED, response, "from #{link}"
				end
				if M2W4TEST_REAL_COMPLEX_M2W_TAGS_ACTUAL != nil && M2W4TEST_REAL_COMPLEX_M2W_TAGS_EXPECTED then
					assert_match M2W4TEST_REAL_COMPLEX_M2W_TAGS_EXPECTED, response, "from #{link}"
				end
				if M2W4TEST_REAL_COMPLEX_M2W_MORE_ACTUAL != nil && M2W4TEST_REAL_COMPLEX_M2W_MORE_EXPECTED then
					assert_match M2W4TEST_REAL_COMPLEX_M2W_MORE_EXPECTED, response, "from #{link}"
				end
				if M2W4TEST_REAL_COMPLEX_M2W_EXCERPT_ACTUAL != nil && M2W4TEST_REAL_COMPLEX_M2W_EXCERPT_EXPECTED then
					assert_match M2W4TEST_REAL_COMPLEX_M2W_EXCERPT_EXPECTED, response, "from #{link}"
				end
				assert_match message, response

				# トラックバックを確認する
				if M2W4TEST_REAL_COMPLEX_M2W_TRACKBACK_RECEIVER_URL != nil && M2W4TEST_REAL_COMPLEX_M2W_TRACKBACK_NOTIFIER_URLS != nil then
					M2W4TEST_REAL_COMPLEX_M2W_TRACKBACK_NOTIFIER_URLS.each do |notifier_url|
						trackbacks = YAML.load(open(notifier_url) { |file| file.read })
						assert trackbacks != nil
						M2W_LOGGER.debug("trackbacks ... #{trackbacks.to_s}")
						assert trackbacks.index { |item| item.has_value?(link) } != nil
					end
				end

				M2W_LOGGER.debug("Finish #{self.class.name}#test_run_complex")
			end
		end

		if M2W4TEST_REAL_USING_BLOGID_TEST then
			def test_run_using_blogid
				M2W_LOGGER.debug("Start  #{self.class.name}#test_run_using_blogid")

				# 事前にメールボックスを空っぽにする
				@mail_testutils.delete_all()
				@mail_testutils4runner.delete_all

				# メールを送信する（ブログ記事投稿）
				from_address = MailAddress.new(M2W4TEST_SENDER_MAILADDRESS)
				to_addresses = [MailAddress.new(M2W4TEST_REPLY_MAILADDRESS)]
				keyword = Time.now.strftime("%Yテ%mス%dト%Hマ%Mー%Sク")
				title = "タイトルテスト@#{keyword}"
				message = "コンテンツテスト@#{keyword}"
content = <<"END_CONTENT"
tit.#{title}
blogid.#{M2W4TEST_WEBLOG_BLOG_ID}

#{message}
END_CONTENT
				@mail_sender.sendmail(Mail.new(@mail_sender.make_title("post"), from_address, to_addresses, content, []))

				sleep(M2W4TEST_SLEEP_MINITES_BEFORE_RUNNING_RUNNER)

				# システムを起動する
				@runner.run(M2W_SYSTEM_CONTINOUS_PROCESSING, M2W_SYSTEM_MAIL_RECEIVER_SLEEPING_TIME)

				# メールの受信を確認する
				mail = @mail_testutils.get_mail()
				assert mail != nil
				assert_equal @mail_sender.make_title("get", M2W4TEST_WEBLOG_BLOG_ID), mail.subject
				assert_equal M2W4TEST_REPLY_MAILADDRESS, mail.from_address.address
				assert_equal from_address.name, mail.from_address.name
				assert_equal 1, mail.to_addresses.size
				assert_equal from_address.address, mail.to_addresses[0].address
				(mail_header, mail_content) = @mail_parser.parse_content(mail.content, {})
				assert_equal 1, mail_header.size, mail_header.to_s
				assert mail_header.has_key?('postid'), mail_header.to_s
				assert_equal 0, mail.attachments.size

				# ブログの投稿を確認する
				(get_result, mail, header, content, contents, attachments, link) = @weblog_testutils.get(M2W4TEST_WEBLOG_BLOG_ID, mail_header['postid'])
				response = open(link) { |stream| stream.read }.encode(M2W_SYSTEM_INNER_ENCODING, M2W4TEST_WEBLOG_ENCODING)
				assert_match title, response
				assert_match message, response

				# メールを送信する（ブログ記事取得）
				postid = mail_header['postid']
content = <<"END_CONTENT"
postid.#{postid}
blogid.#{M2W4TEST_WEBLOG_BLOG_ID}
END_CONTENT
				@mail_sender.sendmail(Mail.new(@mail_sender.make_title("get"), from_address, to_addresses, content, []))

				sleep(M2W4TEST_SLEEP_MINITES_BEFORE_RUNNING_RUNNER)

				# システムを起動する
				@runner.run(M2W_SYSTEM_CONTINOUS_PROCESSING, M2W_SYSTEM_MAIL_RECEIVER_SLEEPING_TIME)

				# メールの受信を確認する
				mail = @mail_testutils.get_mail()
				assert mail != nil
				assert_equal @mail_sender.make_title("edit", M2W4TEST_WEBLOG_BLOG_ID), mail.subject
				assert_equal M2W4TEST_REPLY_MAILADDRESS, mail.from_address.address
				assert_equal from_address.name, mail.from_address.name
				assert_equal 1, mail.to_addresses.size
				assert_equal from_address.address, mail.to_addresses[0].address
				(mail_header, mail_content) = @mail_parser.parse_content(mail.content, {})
				assert_equal 2, mail_header.size, mail_header.to_s
				assert_equal postid, mail_header['postid'], mail_header.to_s
				assert_equal title, mail_header['tit'], mail_header.to_s
				assert_equal 0, mail.attachments.size

				# メールを送信する（ブログ記事編集）
				title = "編集済みタイトルテスト@#{keyword}"
				message = "編集済みコンテンツテスト@#{keyword}"
content = <<"END_CONTENT"
postid.#{postid}
blogid.#{M2W4TEST_WEBLOG_BLOG_ID}
tit.#{title}

#{message}
END_CONTENT
				@mail_sender.sendmail(Mail.new(@mail_sender.make_title("edit"), from_address, to_addresses, content, []))

				sleep(M2W4TEST_SLEEP_MINITES_BEFORE_RUNNING_RUNNER)

				# システムを起動する
				@runner.run(M2W_SYSTEM_CONTINOUS_PROCESSING, M2W_SYSTEM_MAIL_RECEIVER_SLEEPING_TIME)

				# メールの受信を確認する
				mail = @mail_testutils.get_mail()
				assert mail != nil
				assert_equal @mail_sender.make_title("get", M2W4TEST_WEBLOG_BLOG_ID), mail.subject
				assert_equal M2W4TEST_REPLY_MAILADDRESS, mail.from_address.address
				assert_equal from_address.name, mail.from_address.name
				assert_equal 1, mail.to_addresses.size
				assert_equal from_address.address, mail.to_addresses[0].address
				(mail_header, mail_content) = @mail_parser.parse_content(mail.content, {})
				assert_equal 1, mail_header.size, mail_header.to_s
				assert_equal postid, mail_header['postid'], mail_header.to_s
				assert_equal 0, mail.attachments.size

				# ブログの投稿を確認する
				(get_result, mail, header, content, contents, attachments, link) = @weblog_testutils.get(M2W4TEST_WEBLOG_BLOG_ID, mail_header['postid'])
				response = open(link) { |stream| stream.read }.encode(M2W_SYSTEM_INNER_ENCODING, M2W4TEST_WEBLOG_ENCODING)
				assert_match title, response
				assert_match message, response

				# メールを送信する（ブログ記事削除）
				from_address = MailAddress.new(M2W4TEST_SENDER_MAILADDRESS)
				to_addresses = [MailAddress.new(M2W4TEST_REPLY_MAILADDRESS)]
content = <<"END_CONTENT"
postid.#{postid}
blogid.#{M2W4TEST_WEBLOG_BLOG_ID}
END_CONTENT
				@mail_sender.sendmail(Mail.new(@mail_sender.make_title("delete", M2W4TEST_WEBLOG_BLOG_ID), from_address, to_addresses, content, []))

				sleep(M2W4TEST_SLEEP_MINITES_BEFORE_RUNNING_RUNNER)

				# システムを起動する
				@runner.run(M2W_SYSTEM_CONTINOUS_PROCESSING, M2W_SYSTEM_MAIL_RECEIVER_SLEEPING_TIME)

				# メールの受信を確認する
				mail = @mail_testutils.get_mail()
				assert mail != nil
				assert_equal @mail_sender.make_title("deleted", M2W4TEST_WEBLOG_BLOG_ID), mail.subject
				assert_equal M2W4TEST_REPLY_MAILADDRESS, mail.from_address.address
				assert_equal from_address.name, mail.from_address.name
				assert_equal 1, mail.to_addresses.size
				assert_equal from_address.address, mail.to_addresses[0].address
				(mail_header, mail_content) = @mail_parser.parse_content(mail.content, {})
				assert_equal 1, mail_header.size
				assert mail_header.has_key?('postid'), mail_header.to_s
				assert postid == mail_header['postid'], mail_header.to_s
				assert_equal 0, mail.attachments.size

				M2W_LOGGER.debug("Finish #{self.class.name}#test_run_using_blogid")
			end
		end
	end

end
