package org.maskat.demo.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.maskat.demo.AbstractValueObj;


public class SampleServlet extends HttpServlet {

	private String PACKAGE_NAME = "org.maskat.demo.";

	/**
	 * 
	 */
	private static final long serialVersionUID = 6169907056984915450L;

	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {

		request.setCharacterEncoding("UTF-8");

		// DebugUtil.printRequestContent(request);
		// DebugUtil.printRequestHeaderInfo(request);

		// TODO requestAlayoutIDAcomponentIDAeventIDoāAΉNX̃\bhĂяo
		String layoutID = request.getHeader("maskat_layoutID");
		String componentID = request.getHeader("maskat_componentID");
		String eventID = request.getHeader("maskat_eventID");
		Object voObj = null;
		try {

			String packageName = calcPackageName(layoutID, componentID);

			// DAONXCX^X𐶐
			// TODO CX^XLbV
			Class daoClass = Class.forName(packageName + ".DAO");
			Object daoObj = daoClass.newInstance();

			// AbstractValueObj𐶐
			// TODO voObjZbVɃLbVH
			Class voClass = Class.forName(packageName + ".vo.ValueObj");
			voObj = voClass.getConstructor(
					new Class[] { HttpServletRequest.class }).newInstance(
					new Object[] { request });
			// TODO ǂăp[^voɓn̂
			// dXMLAXML->objectAxml bindingi
			// Castor, betwixt, JaxMeȂǂIł

			daoClass.getMethod(eventID, new Class[] { AbstractValueObj.class })
					.invoke(daoObj, new Object[] { voObj });
		} catch (InstantiationException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
		}
		response.setContentType("text/xml;charset=UTF-8");
		PrintWriter out = response.getWriter();
		AbstractValueObj avo = (AbstractValueObj) voObj;

		// TODO vo->NCAg֑Md
		// xml binding
		// xmlXL[}ꍇAXL[}ɍȂƂȂ
		// bindingi͏oXML̃XL[}JX^}CYłׂ
		String temp = avo.tempGetXML();
		out.println(temp);
		System.out.println("NCAg֑Md:" + temp);
	}

	private String calcPackageName(String layoutID, String componentID) {
		if (componentID == null || "".equals(componentID)) {
			return PACKAGE_NAME + layoutID;
		}
		return PACKAGE_NAME + layoutID + "." + componentID;
	}

}