/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.editparts;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

import org.maskat.core.layout.DivSplit;
import org.maskat.core.layout.Component;
import org.maskat.core.layout.Splitter;
import org.maskat.ui.editors.layout.figures.SplitterFigure;
import org.maskat.ui.editors.layout.models.SplitModel;

public class SplitterEditPart extends ComponentEditPart
	implements HorizontalResizable, VerticalResizable {

	/** 0番目のdivSplitは初期表示される */
	private int currentSelectedSplitIdx = 0;

	/** splitの厚さ(幅) */
	private int splitThickness = 8;

	public int getCurrentSelectedSplitIdx() {
		return currentSelectedSplitIdx;
	}
	
	public void activate() {
		super.activate();
		Component model = (Component) getModel();
		model.addPropertyChangeListener(this);
	}

	public void deactivate() {
		Component model = (Component) getModel();
		model.removePropertyChangeListener(this);
		super.deactivate();
	}

	protected IFigure createFigure() {
		return new SplitterFigure();
	}

	private SplitModel split;

//	protected List getModelChildren() {
//		Splitter splitterDef = (Splitter) getModel();
//		List children = splitterDef.getComponents();
//		List result = new ArrayList();
//		for (Iterator it = children.iterator(); it.hasNext();) {
//			DivSplit divSplit = (DivSplit) it.next();
//			result.add(divSplit);
//		}
//
//		split = new SplitModel(splitterDef, splitThickness);
//		result.add(split);
//
//		calcSplitSize();
//		calcDivSplitSize();
//
//		return result;
//	}

	protected List getModelChildren() {
		Splitter splitter = (Splitter) getModel();
		List result = new ArrayList();
		for (Iterator it = splitter.getChildren(); it.hasNext();) {
			result.add(it.next());
		}
		split = new SplitModel(splitter, splitThickness);
		result.add(split);

		calcSplitSize();
		calcDivSplitSize();

		return result;
	}
	protected void refreshVisuals() {
		
		// 制約の取得
		Component comp = (Component) getModel();
		Rectangle constraint = new Rectangle(comp.getLeft(), comp.getTop(), comp
				.getWidth(), comp.getHeight());
		
		// Rectangleオブジェクトを制約としてビューに設定する
		// setLayoutConstraintメソッドは親EditPartから呼び出す
		((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(),
				constraint);
	}

	public void doSwitch() {
		// 0,1切り替える
		currentSelectedSplitIdx = 1 - currentSelectedSplitIdx;
		doRefreshFigure();
	}
	
	public void doSelected(int idx) {
		currentSelectedSplitIdx = idx;
		doRefreshFigure();
	}
	
	private void doRefreshFigure() {
		calcSplitSize();

		for (int i = 0; i < getChildren().size(); i++) {
			AbstractGraphicalEditPart editPart = (AbstractGraphicalEditPart) getChildren().get(i);
			if (editPart instanceof SplitEditPart) {
				this.setLayoutConstraint(editPart, editPart.getFigure(), new Rectangle(
						split.getX(), split.getY(), split.getWidth(), split.getHeight()));
			}
		}
	}

	private void calcSplitSize() {
		Splitter splitterDef = (Splitter) getModel();
		boolean isHorizontal = splitterDef.isHorizontal();
		if (isHorizontal) {
			split.setWidth(splitThickness);
			split.setHeight(splitterDef.getHeight() - 1);
			split.setY(0);
			if (currentSelectedSplitIdx == 0) {
				split.setX(splitterDef.getWidth() - splitThickness - 1);
			} else {
				split.setX(0);
			}
		} else {
			// vertical
			split.setWidth(splitterDef.getWidth() - 1);
			split.setHeight(splitThickness);
			split.setX(0);
			if (currentSelectedSplitIdx == 0) {
				split.setY(splitterDef.getHeight() - splitThickness - 1);
			} else {
				split.setY(0);
			}
		}
	}

	private void calcDivSplitSize() {
		Splitter splitterDef = (Splitter) getModel();
		boolean isHorizontal = splitterDef.isHorizontal();
		DivSplit div0 = (DivSplit) splitterDef.getChildByTypeIdx(DivSplit.class,0);
		DivSplit div1 = (DivSplit) splitterDef.getChildByTypeIdx(DivSplit.class,1);
		if (isHorizontal) {
			if (div0 != null) {
				// 左詰め
				div0.setLeft(0);
				div0.setTop(0);
				div0.setWidth(splitterDef.getWidth() - splitThickness - 1);
				div0.setHeight(splitterDef.getHeight() - 1);
			}
			if (div1 != null) {
				// 右詰め
				div1.setLeft(splitThickness);
				div1.setTop(0);
				div1.setWidth(splitterDef.getWidth() - splitThickness - 1);
				div1.setHeight(splitterDef.getHeight() - 1);
			}
		} else {
			if (div0 != null) {
				// 上詰め
				div0.setLeft(0);
				div0.setTop(0);
				div0.setWidth(splitterDef.getWidth() - 1);
				div0.setHeight(splitterDef.getHeight() - splitThickness - 1);
			}
			if (div1 != null) {
				// 下詰め
				div1.setLeft(0);
				div1.setTop(splitThickness);
				div1.setWidth(splitterDef.getWidth() - 1);
				div1.setHeight(splitterDef.getHeight() - splitThickness - 1);
			}
		}
	}

	public void propertyChange(PropertyChangeEvent evt) {
		calcSplitSize();
		calcDivSplitSize();
//		refreshVisuals();
		super.propertyChange(evt);
	}
}

