/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.XYLayout;

import org.maskat.core.layout.Popup;

public class PopupFigure extends TreeViewFigure {

	private Popup theDef;

	public PopupFigure(Popup def) {
		theDef = def;
		setForegroundColor(ColorConstants.black);
		setBorder(new LineBorder(1));
		setLayoutManager(new XYLayout());
	}

	protected void paintFigure(Graphics graphics) {
		super.paintFigure(graphics);
		graphics.translate(bounds.x, bounds.y);
		graphics.drawText(theDef.getTitle(), 0, 0);
		//graphics.drawLine(0, 20, bounds.width, 20);
		graphics.translate(-bounds.x, -bounds.y);
	}
}
