/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties;

import org.eclipse.ui.views.properties.PropertyDescriptor;

import org.maskat.core.layout.Radio;
import org.maskat.core.layout.RadioGroup;
import org.maskat.core.layout.RadioMember;
import org.maskat.ui.views.properties.descriptor.BooleanComboBoxPropertyDescriptor;
import org.maskat.ui.views.properties.descriptor.MaskatTextPropertyDescriptor;

public class RadioPropertySource extends AbstractComponentPropertySource {

	public static final String PROP_NAME = "_prop_name_";
	
	public static final String PROP_LEFT = "_prop_left_";
	
	public static final String PROP_TOP = "_prop_top_";
	
	public static final String PROP_TEXT = "_prop_text_";
	
	public static final String PROP_CHECKED = "_prop_checked_";
	
	public static final String PROP_CLASSNAME = "_prop_className_";
	
	public static final String PROP_ENABLE = "_prop_enable_";

	public static final String PROP_RADIO_GROUP = "_prop_radio_group_";
	
	public static final String PROP_RADIO_GROUP_TABINDEX = "_prop_radio_group_tabindex_";

	public RadioPropertySource(Radio radio) {
		super(radio);
	}
	
	protected void initialize() {
		descriptor = new PropertyDescriptor[] {
				  new MaskatTextPropertyDescriptor(PROP_NAME, "name"),
				  new MaskatTextPropertyDescriptor(PROP_LEFT, "left"),
				  new MaskatTextPropertyDescriptor(PROP_TOP, "top"),
				  //new MaskatTextPropertyDescriptor(PROP_RADIO_GROUP_TABINDEX, "tabIndex"),
				  new MaskatTextPropertyDescriptor(PROP_TEXT, "text"),
				  new BooleanComboBoxPropertyDescriptor(PROP_ENABLE, "enable"),
				  new BooleanComboBoxPropertyDescriptor(PROP_CHECKED, "checked"),
				  new MaskatTextPropertyDescriptor(PROP_CLASSNAME, "className"),
				  new MaskatTextPropertyDescriptor(PROP_RADIO_GROUP, "group")};
		
		//make sure the "..." values are the same as bean's properties.
	    propMap.put(PROP_NAME, "name");
	    propMap.put(PROP_LEFT, "left");
	    propMap.put(PROP_TOP, "top");
	    propMap.put(PROP_TEXT, "text");
	    propMap.put(PROP_CHECKED, "checked");
	    propMap.put(PROP_CLASSNAME, "className");
	    propMap.put(PROP_ENABLE, "enable");
	    propMap.put(PROP_RADIO_GROUP, "group");
	    //propMap.put(PROP_RADIO_GROUP_TABINDEX, "tabIndex");

	}
	
	protected void doSetPropertyValue(Object id, Object value) {
		if (PROP_RADIO_GROUP.equals(id)) {
			// TODO sync group tabIndex(set tabIndex according to the group)
			((Radio)bean).getLayout().removeRadioMemberFromGroup(((Radio)bean).getGroup(),
					((Radio)bean).getName());
			if (value != null) {
				RadioGroup rgd = ((Radio)bean).getLayout().findRadioGroupDef(
						(String) value);
				if (rgd == null)
					rgd = ((Radio)bean).getLayout().createRadioGroupDef((String) value);

				RadioMember rm = new RadioMember();
				rm.setRef(((Radio)bean).getName());
				rgd.addChild(rm);
			}
		}
		super.doSetPropertyValue(id, value);
	}
}
