/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties.tabbed.masterdetails;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

import org.maskat.ui.ISharedImages;
import org.maskat.ui.MaskatUIPlugin;
import org.maskat.ui.Messages;
import org.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;

public class EventBeansLabelProvider extends LabelProvider {

	private static final String NODE_NOT_DEFINED = Messages
			.getString("eventBeansLabel.nodeNotDefined"); //$NON-NLS-1$

	public Image getImage(Object element) {
		return MaskatUIPlugin.getImage(ISharedImages.IMG_OBJ_ELEMENT);
	}

	public String getText(Object element) {
		if (element instanceof ITreeNode) {
			return ((ITreeNode) element).getDisplayText();
		}
		return NODE_NOT_DEFINED;
	}

}
