/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.editparts;

import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.GraphicalEditPart;

import org.maskat.core.layout.Combo;
import org.maskat.core.layout.ComboItem;
import org.maskat.core.layout.Component;
import org.maskat.ui.ISharedImages;
import org.maskat.ui.MaskatUIPlugin;
import org.maskat.ui.editors.layout.figures.ComboFigure;

public class ComboEditPart extends ComponentEditPart
	implements HorizontalResizable {

	public static final int MIN_HEIGHT_ITEM = 15;

	public void activate() {
		this.addEditPartListener(new EditPartListener.Stub() {
			public void selectedStateChanged(EditPart part) {
				if (part.getSelected() == SELECTED_PRIMARY) {
					setShowChildren(true);
				} else {
					setShowChildren(false);
				}
				refresh();
				super.selectedStateChanged(part);
			}
		});
		((Component) getModel()).addPropertyChangeListener(this);
		super.activate();
	}

	public boolean isShowChildren() {
		return ((ComboFigure) this.getFigure()).isChildrenShown();
	}

	public void setShowChildren(boolean showChildren) {
		((ComboFigure) this.getFigure()).setChildrenShown(showChildren);
		this.refresh();
		if (!showChildren) {
			((ComboFigure) this.getFigure()).setIcon(
				MaskatUIPlugin.getImage(ISharedImages.IMG_COMBOBOXDROPDOWN));
		} else {
			((ComboFigure) this.getFigure()).setIcon(null);
		}
	}

	protected IFigure createFigure() {
		return new ComboFigure();
	}

	protected List getModelChildren() {
		Combo cd = (Combo) getModel();
		List result = cd.getUnmodifiableChildren();
		return (result == null) ? Collections.EMPTY_LIST : result; 
	}

	public void propertyChange(PropertyChangeEvent evt) {
		if ("addChild".equals(evt.getPropertyName())
			|| "removeChild".equals(evt.getPropertyName())) {
			if (getParent() != null) {
				refresh();
			}
		}
		if (getParent() != null) {
//			refreshVisuals();
			super.propertyChange(evt);
		}
	}
	
	protected void refreshVisuals() {
		Combo combo = (Combo) getModel();
		int displayHeight = ComboFigure.DEFAULT_HEIGHT;
		if (isShowChildren()) {
//			int heightItem = CUtil.safeToInt(combo.getHeightItem());
			int heightItem = combo.getHeightItem();
			heightItem = Math.max(heightItem, MIN_HEIGHT_ITEM);
			Iterator it = combo.getTypedChildren(ComboItem.class);
			int childCount = 0;
			for (; it != null && it.hasNext(); it.next()) {
				childCount++;
			}
			displayHeight += heightItem * childCount;
			this.getFigure().setOpaque(true);
		} else {
			this.getFigure().setOpaque(false);
		}
		Rectangle constraint = new Rectangle(combo.getLeft(), combo.getTop(), 
				combo.getWidth(), displayHeight);

		GraphicalEditPart part = (GraphicalEditPart) getParent();
		if (part != null) {
			part.setLayoutConstraint(this, getFigure(), constraint);
		}
		// 子EditPartのリフレッシュ
		for (Iterator it = this.getChildren().iterator(); it.hasNext();) {
			((EditPart) it.next()).refresh();
		}
	}
}
