/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.editparts;

import java.beans.PropertyChangeEvent;
import java.util.List;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;

import org.maskat.core.MaskatElement;
import org.maskat.core.layout.DivSplit;
import org.maskat.core.layout.Component;
import org.maskat.ui.editors.layout.figures.DivSplitFigure;

public class DivSplitEditPart extends ComponentEditPart
	implements HorizontalResizable, VerticalResizable {

	protected IFigure createFigure() {
		DivSplit divSplit = (DivSplit) getModel();
		
		// divSplitのインデックスを取得
//		int idx = divSplit.getContainer().getChildIdx(divSplit);
		int idx = divSplit.getParent().getChildIdx(divSplit);
		
		DivSplitFigure splitPageFig = new DivSplitFigure(idx);
		SplitterEditPart splitterEditPart = (SplitterEditPart) this.getParent();
		
		// 該当選択されたdivSplitはvisible、ではなければinvisible
		if (divSplit.getIdx() == splitterEditPart.getCurrentSelectedSplitIdx()) {
			splitPageFig.setVisible(true);
		} else {
			splitPageFig.setVisible(false);
		}
		return splitPageFig;
	}

	protected List getModelChildren() {
		List result = null;
		if (getModel() instanceof MaskatElement) {
			result = ((MaskatElement) getModel()).getUnmodifiableChildren();
		}
		return (result != null) ? result : super.getModelChildren(); 
	}
	
	protected void refreshVisuals() {
		
		// 制約の取得
		Component comp = (Component) getModel();
		Rectangle constraint = new Rectangle(comp.getLeft(), comp.getTop(), 
				comp.getWidth(), comp.getHeight());

		// Rectangleオブジェクトを制約としてビューに設定する
		// setLayoutConstraintメソッドは親EditPartから呼び出す
		((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(),constraint);
	}

	public void propertyChange(PropertyChangeEvent evt) {
		if ("addChild".equals(evt.getPropertyName())
				|| "removeChild".equals(evt.getPropertyName())) {
			refreshChildren();
		}
		super.propertyChange(evt);
	}
}
